#define VERSION "0.14"

/* Normally found in sys/param.h but LCC-Win32 doesn't have it. */
#ifndef MAXPATHLEN
#define MAXPATHLEN 1024
#endif

#define TRUE 1
#define FALSE 0

#if defined(WIN32) || defined(__EMX__)
/* This assumes a WeatherNode directory structure */
#define BASEDIR "\\weather\\wxdata\\"
#define TRACKDIR BASEDIR "rxtrack"
#define TMPDIR BASEDIR "rxtmp\\tmp"
#define OUTDIR BASEDIR "newfiles"
#define NULLDEVICE "NUL"
#define COPYCMD "copy %s %s"
#define PATHSEPARATOR "\\"
#else
#ifdef linux
#define TMPDIR "/var/tmp"
#else
#define TMPDIR P_tmpdir
#endif
#define OUTDIR "."
#define NULLDEVICE "/dev/null"
#define COPYCMD "/bin/cp -f %s %s"
#define PATHSEPARATOR "/"
#endif

#ifndef UNZIPPATH
#define UNZIPPATH "unzip"
#endif
#define UNZIPPARAMS " -qoj %s -d %s"

#ifndef BEEPMODE
#define BEEPMODE 0
#endif

#ifndef OUTMODE
#define OUTMODE 2
#endif

#ifndef DEBUG
#define DEBUG 0
#endif

#define MAXBLOCKS 500

struct QBT {	/* http://iwin.nws.noaa.gov/emwin/winpro.htm */
  unsigned char preamble[6];
  unsigned char header[80];
  unsigned char data[1024];
  unsigned char trailer[6];
} qbtpacket;

struct PKTATTR {
  unsigned char filename[13];	/* Null-terminated. */
  unsigned int blocknum, totalblocks;
  unsigned long checksum;
  unsigned char datestamp[21];	/* Null-terminated. */
  unsigned char *data;
} pktattr;

#ifdef __EMX__
/* Under OS/2 the standard chdir() and getcwd() behave differently
   so we redefine these to their UNIX equivalents. */
#define chdir _chdir2
#define getcwd _getcwd2
#endif

#ifdef WIN32
/* perror() is useless with Windows sockets. */
#define psocketerror(S) \
  fprintf(stderr,"%s:  WSA error #%d\n", S, WSAGetLastError());
#else
#define psocketerror(S) perror(S);
#endif

