/*
 * A graphics viewing program based on the Athena viewport
 * widget. This will display plots that are larger than the screen.
 *
 * A. Maitland Bottoms
 * 25 September 1996
 *
 * To Do:
 *    - Dis-allow resizing the image widget to be larger than its
 *      background pixmap.
 *
 *    - Save .xpm and .pgm files. (Maybe .ppm)
 *
 *    - More robust colormap handling (anything would be a start).
 *
 *    - Better file picking interface? fetch via WWW? CGI mode where
 *      it generates an image on the fly for UTF Web Servers?
 */

#include <stdio.h>
#include <stdlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>
#include "utf.h"

/*
 * Global variables. 
 */
int debug=0,global_error_code;
unsigned long global_serial_num;
int (*global_old_error_handler)();

Widget toplevel;
Widget view;
Widget plot;
Pixmap plotPixmap;
int currX, currY;

/*
 * external function definitions.
 */
extern int SetWidgetColor(Widget w);
char *readpgm(char *filename,int *rows,int *cols);

/*
 * Resources...
 */
String fallback_resources[] = {
    "*.background: lightSkyBlue",
    "*Label*shadowWidth: 2",
    "*shapeStyle: Rectangle",
    "*beNiceToColormap: False",
    "*.view.allowHoriz: True",
    "*.view.allowVert: True",
    "*.view.height: 256",
    "*.view.width: 256",
    "*.font: *charter-medium-i-*-180-*",
    NULL,
};

int
main(int argc,char *argv[])
{
  int num_args;
  Arg args[10];
  char *im;
  int rows,cols;
  XImage *ximage;
  XTextItem Annotation;

  XtAppContext app_con;

  toplevel = XtAppInitialize(&app_con, "XUtf",
			     NULL, ZERO,
			     &argc, argv, fallback_resources,
			     NULL, ZERO);

  view = XtCreateManagedWidget("view", viewportWidgetClass, toplevel,
				NULL, ZERO);

  plot = XtCreateManagedWidget("plot", boxWidgetClass,
				view, NULL, ZERO);

  XtRealizeWidget(toplevel);


  /* Get image data */
  if ((argc>2)&&(0==strncmp(argv[1],"-pgm",4))) {
    im = readpgm(argv[2],&rows,&cols);
    argc -= 2;
    argv = &(argv[2]);

    /* Create XImage structure with this data */
    ximage = XCreateImage(XtDisplay(toplevel),
			  DefaultVisualOfScreen(XtScreen(toplevel)),
			  8,ZPixmap,0,im,
			  cols,rows,8,cols);

    /* Create a pixmap on the X server */
    plotPixmap = XCreatePixmap(XtDisplay(toplevel),XtWindow(plot),
			       cols,rows,8);

    /* Transfer the image data from this program to the X server */
    XPutImage(XtDisplay(toplevel), plotPixmap,
	      DefaultGCOfScreen(XtScreen(toplevel)),
	      ximage,0,0,0,0,cols,rows);

  } else {
    /* We need this pixmap to draw on */
    cols=2048;rows=2048;
    plotPixmap = XCreatePixmap(XtDisplay(toplevel),XtWindow(plot),
			       cols,rows,DefaultDepthOfScreen(XtScreen(plot)));
  }

  /* Associate the pixmap with the widget background */
  num_args = 0;
  XtSetArg(args[num_args], XtNbackgroundPixmap, plotPixmap); num_args++;
  XtSetValues(plot, args, num_args);

  /* Oh yeah, it's in color. Associate a colormap with the shell widget */
  /* SetWidgetColor(toplevel); */

  /* Set initial layout preferences... */
  num_args = 0;
  XtSetArg(args[num_args], XtNheight, rows); num_args++;
  XtSetArg(args[num_args], XtNwidth, cols); num_args++;
  XtSetValues(plot, args, num_args);

  XDrawLine(XtDisplay(plot),plotPixmap,
            DefaultGCOfScreen(XtScreen(plot)),
            0, 0, rows, cols);

  Annotation.chars = "Demo 1";
  Annotation.nchars = 6;
  Annotation.font = XLoadFont(XtDisplay(plot),"9x15");
  /* XDrawText(XtDisplay(plot),plotPixmap,DefaultGCOfScreen(XtScreen(plot)),
     cols/2,20,&Annotation,1); */

  utf(argc,argv);

  XtAppMainLoop(app_con);
  return(0);
}

char *
readpgm(char *filename,int *rows,int *cols)
{
  FILE *fp;
  char string[512];
  int max;
  char *imdata;

  /* read PGM file... */
  fp = fopen(filename,"r");
  fscanf(fp,"%s\n",string);
  fscanf(fp,"%d %d\n",cols,rows);
  fscanf(fp,"%d\n",&max);
  if (debug)
    printf("Reading %d x %d (x%d) image from %s.\n",*cols,*rows,max,filename);
  imdata = (char *)malloc((*rows)*(*cols));
  fread(imdata,(*rows)*(*cols),1,fp);
  fclose(fp);

  return(imdata);
}

int
moveto(int x, int y)
{
  currX=x;
  currY=y;
  return(0);
}

int
moverel(int x, int y)
{
  currX+=x;
  currY+=y;
  return(0);
}

int
drawto(int x, int y)
{
  XDrawLine(XtDisplay(plot),plotPixmap,
            DefaultGCOfScreen(XtScreen(plot)),
            currX, currY, x, y);

  currX=x;
  currY=y;

  return(0);
}

int
drawrel(int x, int y)
{
  XDrawLine(XtDisplay(plot),plotPixmap,
            DefaultGCOfScreen(XtScreen(plot)),
            currX, currY, currX+x, currY+y);

  currX+=x;
  currY+=y;

  return(0);
}
