#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#if defined(_WIN32)
# include <gdk/gdkwin32.h>
# define HAVE_WIN32
#else
# include <gdk/gdkx.h>
# define HAVE_X
#endif
#include <unistd.h>

#include "../include/string.h"
#include "../include/disk.h"

#include "guiutils.h"
#include "cdialog.h"
#include "pulist.h"

#include "cfg.h"
#include "cfgfio.h"
#include "edvtypes.h"
#include "edvid.h"
#include "edvpixmap.h"
#include "edvcursor.h"
#include "edvobj.h"
#include "edvrecbin.h"
#include "edvdate.h"
#include "edvhistory.h"
#include "edvobj.h"
#include "edvrecbinfio.h"
#include "edvdevices.h"
#include "edvdevicesfio.h"
#include "edvmimetypes.h"
#include "edvmimetypesfio.h"
#include "browser.h"
#include "recbin.h"
#include "recbindeskicon.h"
#include "findwin.h"
#include "propdlg.h"
#include "historywin.h"
#include "rundlg.h"
#include "optwin.h"
#include "endeavour.h"
#include "edvcb.h"
#include "edvop.h"
#include "edvinterps.h"
#include "edvutils.h"
#include "edvutilsgtk.h"

#define NEED_EDV_CFG_LIST_SOURCE
#include "edvcfglist.h"
#include "config.h"


static GList *g_list_new_length(guint length, gpointer datas);
static void g_list_set_nth_data(GList *glist, guint n, gpointer data);

static void EDVDoCreateStandardConfiguration(edv_core_struct *core_ptr);
static void EDVDoCreateStandardCursors(edv_core_struct *core_ptr);

edv_core_struct *EDVNew(
	gint argc, gchar *argv[],
	gint *err_rtn
);
void EDVDelete(
	edv_core_struct *core_ptr, gboolean save_config
);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Creates a new GList of the specified length.
 */
static GList *g_list_new_length(guint length, gpointer datas)
{
	gint i;
	GList *glist = NULL;

	for(i = 0; i < length; i++)
	    glist = g_list_append(glist, datas);

	return(glist);
}

/*
 *	Sets the data of the nth item in the GList.
 */
static void g_list_set_nth_data(GList *glist, guint n, gpointer data)
{
	glist = g_list_nth(glist, n);
	if(glist != NULL)
	    glist->data = data;
}


/*
 *      Sets configuration values on the given core structure to their
 *	default values.
 */
static void EDVDoCreateStandardConfiguration(edv_core_struct *core_ptr)
{
	gchar	*startup_dir,
		*tmp_dir,
		*home_dir,
		*global_data_dir,
		*local_data_dir,
		*global_config_dir;
	GList *glist;
	cfg_intlist_struct *intlist;
	cfg_color_struct *color;
	cfg_accelkey_list_struct *ak_list;
	const cfg_item_struct src_cfg_list[] = EDV_CONFIGURATION_LIST;
	cfg_item_struct *cfg_list;


	/* Copy the source configuration list to the target
	 * configuration list on the core
	 */
	core_ptr->cfg_list = cfg_list = CFGItemListCopyList(src_cfg_list);
	if(cfg_list == NULL)
	    return;


	/* Begin fetching general values */

	/* Startup Directory */
	startup_dir = EDVGetCWD();
	if(startup_dir == NULL)
	    startup_dir = STRDUP("/");

	/* Home Directory */
	home_dir = STRDUP(core_ptr->home_dir);
	if(home_dir == NULL)
	    home_dir = STRDUP("/");

	/* Global Data Directory */
	global_data_dir = STRDUP(EDV_DEF_GLOBAL_DATA_DIR);

	/* Local Data Directory */
	local_data_dir = STRDUP(PrefixPaths(
	    home_dir, EDV_DEF_LOCAL_DATA_DIR
	));

	/* Global Configuration Directory */
	global_config_dir = STRDUP(EDV_DEF_GLOBAL_CONFIG_DIR);

	/* Tempory Directory */
	tmp_dir = STRDUP(g_getenv(ENV_VAR_NAME_TMPDIR));
	if(tmp_dir == NULL)
#if defined(P_tmpdir)
	    tmp_dir = STRDUP(P_tmpdir);
#elif defined(_WIN32)
	    tmp_dir = STRDUP("C:\\TEMP");
#else
	    tmp_dir = STRDUP("/tmp");
#endif


	/* Begin setting default configuration values */

	/* Version */
	EDV_SET_I(EDV_CFG_PARM_VERSION_MAJOR, PROG_VERSION_MAJOR);
	EDV_SET_I(EDV_CFG_PARM_VERSION_MINOR, PROG_VERSION_MINOR);
	EDV_SET_I(EDV_CFG_PARM_VERSION_RELEASE, PROG_VERSION_RELEASE);

	/* Directories */
	EDV_SET_S(EDV_CFG_PARM_DIR_START_UP, startup_dir);
	EDV_SET_S(EDV_CFG_PARM_DIR_GLOBAL, global_data_dir);
	EDV_SET_S(EDV_CFG_PARM_DIR_LOCAL, local_data_dir);
	EDV_SET_S(EDV_CFG_PARM_DIR_GLOBAL_CONFIG, global_config_dir);
	EDV_SET_S(EDV_CFG_PARM_DIR_TMP, tmp_dir);

	/* Files */
	/* Recycled Objects Index */
	EDV_SET_S(
	    EDV_CFG_PARM_FILE_RECYCLED_INDEX,
	    PrefixPaths(local_data_dir, EDV_DEF_RECYCLED_INDEX_FILE)
	);
	/* MIME Types (Local) */
#if defined(DEBIAN)
        EDV_SET_S(              
            EDV_CFG_PARM_FILE_MIME_TYPES,
            PrefixPaths(global_config_dir, EDV_DEF_MIMETYPES_FILE)
        );
#else
	EDV_SET_S(
	    EDV_CFG_PARM_FILE_MIME_TYPES,
	    PrefixPaths(local_data_dir, EDV_DEF_MIMETYPES_FILE)
	);
#endif
	/* MIME Types (Global) */
	EDV_SET_S(
	    EDV_CFG_PARM_FILE_MIME_TYPES_GLOBAL,
	    PrefixPaths(global_data_dir, EDV_DEF_MIMETYPES_FILE)
	);
	/* Devices */
	EDV_SET_S(
	    EDV_CFG_PARM_FILE_DEVICES,
	    PrefixPaths(local_data_dir, EDV_DEF_DEVICES_FILE)
	);
	/* History file */
	EDV_SET_S(
	    EDV_CFG_PARM_FILE_HISTORY,
	    PrefixPaths(local_data_dir, EDV_DEF_HISTORY_FILE)
	);
	/* Browser Location History */
	EDV_SET_S(
	    EDV_CFG_PARM_FILE_BROWSER_LOCATION_HISTORY,
	    PrefixPaths(local_data_dir, EDV_DEF_BROWSER_LOCATION_HISTORY_FILE)
	);
	/* Image Browser Location History */
	EDV_SET_S(
	    EDV_CFG_PARM_FILE_IMBR_LOCATION_HISTORY,
	    PrefixPaths(local_data_dir, EDV_DEF_IMBR_LOCATION_HISTORY_FILE)
	);
	/* Archiver Location History */
	EDV_SET_S(
	    EDV_CFG_PARM_FILE_ARCHIVER_LOCATION_HISTORY,
	    PrefixPaths(local_data_dir, EDV_DEF_ARCHIVER_LOCATION_HISTORY_FILE)
	);
	/* Run Dialog History */
	EDV_SET_S(
	    EDV_CFG_PARM_FILE_RUNDLG_HISTORY,
	    PrefixPaths(local_data_dir, EDV_DEF_RUN_HISTORY_FILE)
	);

	/* Programs */
	/* Default Viewer */
	EDV_SET_S(EDV_CFG_PARM_PROG_DEF_VIEWER, EDV_DEF_VIEWER_CMD);
	/* Terminal */
	EDV_SET_S(EDV_CFG_PARM_PROG_TERMINAL, EDV_DEF_TERMINAL_PROG);
	/* Run In Terminal Command */
	EDV_SET_S(EDV_CFG_PARM_PROG_TERMINAL_RUN, EDV_DEF_RUN_IN_TERMINAL_CMD);
	/* ARJ Archiver */
	EDV_SET_S(EDV_CFG_PARM_PROG_ARJ, "/usr/bin/arj");
	/* LHA Archiver */
	EDV_SET_S(EDV_CFG_PARM_PROG_LHA, "/usr/bin/lha");
	/* RAR Archiver */
	EDV_SET_S(EDV_CFG_PARM_PROG_RAR, "/usr/bin/rar_static");
	/* RedHat Program Manager Archiver */
	EDV_SET_S(EDV_CFG_PARM_PROG_RPM, "/bin/rpm");
	/* Tape Archive Archiver */
	EDV_SET_S(EDV_CFG_PARM_PROG_TAR, "/bin/tar");
	/* PKZip Archiver */
	EDV_SET_S(EDV_CFG_PARM_PROG_ZIP, "/usr/bin/zip");
	EDV_SET_S(EDV_CFG_PARM_PROG_UNZIP, "/usr/bin/unzip");
	/* Compress */
	EDV_SET_S(EDV_CFG_PARM_PROG_COMPRESS, "/usr/bin/compress");
	EDV_SET_S(EDV_CFG_PARM_PROG_UNCOMPRESS, "/usr/bin/uncompress");
	/* GZip */
	EDV_SET_S(EDV_CFG_PARM_PROG_GZIP, "/bin/gzip");
	EDV_SET_S(EDV_CFG_PARM_PROG_GUNZIP, "/bin/gunzip");
	/* BZip2 */
	EDV_SET_S(EDV_CFG_PARM_PROG_BZIP2, "/bin/bzip2");
	EDV_SET_S(EDV_CFG_PARM_PROG_BUNZIP2, "/bin/bunzip2");
	/* Download Front End */
	EDV_SET_S(EDV_CFG_PARM_PROG_NET_DOWNLOAD, EDV_DEF_DOWNLOAD_FRONT_PROG);
	/* E-Mail Client */
	EDV_SET_S(EDV_CFG_PARM_PROG_MAIL_CLIENT, EDV_DEF_MAIL_CLIENT_PROG);

	/* GTK Style Override */
	EDV_SET_B(EDV_CFG_PARM_GTK_STYLE_OVERRIDE, FALSE);

	/* Master Write Protect */
	EDV_SET_B(EDV_CFG_PARM_WRITE_PROTECT, TRUE);

	/* Record Start Up Directory */
	EDV_SET_B(EDV_CFG_PARM_RECORD_START_UP_DIR, TRUE);

	/* Lists Middle Click Scroll */
	EDV_SET_B(EDV_CFG_PARM_LISTS_MIDDLE_CLICK_SCROLL, FALSE);

	/* Right Click Menus Selects */
	EDV_SET_B(EDV_CFG_PARM_RIGHT_CLICK_MENU_SELECTS, TRUE);

	/* Date Relativity */
	EDV_SET_I(EDV_CFG_PARM_DATE_RELATIVITY, (gint)EDV_DATE_RELATIVITY_ABSOLUTE);
	/* Date Format (see strftime()) */
	EDV_SET_S(EDV_CFG_PARM_DATE_FORMAT, "%b %d %H:%M");

	/* Conserve Memory */
	EDV_SET_B(EDV_CFG_PARM_CONSERVE_MEMORY, FALSE);

	/* Image Quality (0=poor/fastest 1=standard/optimul 2=best/slowest) */
	EDV_SET_I(EDV_CFG_PARM_IMAGE_QUALITY, 1);

	/* Lists Double Buffer */
	EDV_SET_B(EDV_CFG_PARM_LISTS_DOUBLE_BUFFER, TRUE);

	/* Lists Animate Updates */
	EDV_SET_B(EDV_CFG_PARM_LISTS_ANIMATE_UPDATES, TRUE);

	/* Tree Expand Optimize Position */
	EDV_SET_B(EDV_CFG_PARM_TREE_EXPAND_OPTIMIZE_POS, TRUE);

	/* Show Tooltips */
	EDV_SET_B(EDV_CFG_PARM_SHOW_TOOLTIPS, TRUE);

	/* Show Texttips */
	EDV_SET_B(EDV_CFG_PARM_SHOW_TEXTTIPS, TRUE);      

	/* Window Cascade Offset */
	EDV_SET_I(
	    EDV_CFG_PARM_WINDOW_CASCADE_OFFSET_X,
	    EDV_DEF_WINDOW_CASCADE_OFFSET_X
	);
	EDV_SET_I(
	    EDV_CFG_PARM_WINDOW_CASCADE_OFFSET_Y,
	    EDV_DEF_WINDOW_CASCADE_OFFSET_Y
	);


	/* Confirm Copy */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_COPY, TRUE);
	/* Confirm Move */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_MOVE, TRUE);
	/* Confirm Link */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_LINK, TRUE);
	/* Confirm Delete */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_DELETE, TRUE);
	/* Confirm Add To Archive */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_ARCHIVE_ADD, TRUE);
	/* Confirm Extract From Archive */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_ARCHIVE_EXTRACT, TRUE);
	/* Confirm Delete From Archive */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_ARCHIVE_DELETE, TRUE);
	/* Confirm Recover */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_RECOVER, TRUE);
	/* Confirm Purge */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_PURGE, TRUE);
	/* Confirm Downloads */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_DOWNLOAD, TRUE);

	/* Maximum History Events */
	EDV_SET_I(EDV_CFG_PARM_HISTORY_EVENTS_MAX, 500);

	/* Recycle Bin Size Warn (in bytes) */
	EDV_SET_UL(EDV_CFG_PARM_RECBIN_SIZE_WARN, 10000000l);

	/* Delete Method (Recycle or Purge on delete) */
	EDV_SET_I(EDV_CFG_PARM_DELETE_METHOD, (gint)EDV_DELETE_METHOD_MOVE_TO_RECBIN);

	/* Add To Archive */
	/* Compression Level (0 to 100) */
	EDV_SET_I(EDV_CFG_PARM_ARCHIVE_ADD_COMPRESSION, 100);
	/* Recursive */
	EDV_SET_B(EDV_CFG_PARM_ARCHIVE_ADD_RECURSIVE, TRUE);
	/* Dereference Links */
	EDV_SET_B(EDV_CFG_PARM_ARCHIVE_ADD_DEREFERENCE_LINKS, FALSE);

	/* Extract From Archive */
	/* Preserve Directories */
	EDV_SET_B(EDV_CFG_PARM_ARCHIVE_EXTRACT_PRESERVE_DIR, TRUE);
	/* Preserve Time Stamps */
	EDV_SET_B(EDV_CFG_PARM_ARCHIVE_EXTRACT_PRESERVE_TIMESTAMPS, TRUE);

	/* Mailcap Import Options */
	EDV_SET_B(EDV_CFG_PARM_MAILCAP_IMPORT_UPDATE, TRUE);
	EDV_SET_B(EDV_CFG_PARM_MAILCAP_IMPORT_ONLY_NEWER, TRUE);
	/* Media Types Import Options */
	EDV_SET_B(EDV_CFG_PARM_MEDIA_TYPES_IMPORT_UPDATE, TRUE);
	EDV_SET_B(EDV_CFG_PARM_MEDIA_TYPES_IMPORT_ONLY_NEWER, TRUE);

	/* Sounds */
	EDV_SET_B(EDV_CFG_PARM_SOUND_USE_SYSTEM, TRUE);
	EDV_SET_S(EDV_CFG_PARM_SOUND_PLAY_BEEP, "");
	EDV_SET_S(EDV_CFG_PARM_SOUND_PLAY_INFO, "");
	EDV_SET_S(EDV_CFG_PARM_SOUND_PLAY_QUESTION, "");
	EDV_SET_S(EDV_CFG_PARM_SOUND_PLAY_WARNING, "");
	EDV_SET_S(EDV_CFG_PARM_SOUND_PLAY_ERROR, "");
	EDV_SET_S(EDV_CFG_PARM_SOUND_PLAY_COMPLETED, "");

	/* Startup Window */
	EDV_SET_B(EDV_CFG_PARM_STARTUP_BROWSER, TRUE);
	EDV_SET_B(EDV_CFG_PARM_STARTUP_IMBR, FALSE);
	EDV_SET_B(EDV_CFG_PARM_STARTUP_ARCHIVER, FALSE);
	EDV_SET_B(EDV_CFG_PARM_STARTUP_RECBIN, FALSE);


	/* File Browser Geometry */
	EDV_SET_I(EDV_CFG_PARM_BROWSER_X, 0);
	EDV_SET_I(EDV_CFG_PARM_BROWSER_Y, 0);
	EDV_SET_I(EDV_CFG_PARM_BROWSER_WIDTH, EDV_DEF_BROWSER_WIDTH);
	EDV_SET_I(EDV_CFG_PARM_BROWSER_HEIGHT, EDV_DEF_BROWSER_HEIGHT);
	EDV_SET_I(EDV_CFG_PARM_BROWSER_PANED_POSITION, EDV_DEF_BROWSER_PANED_POSITION);

	EDV_SET_B(EDV_CFG_PARM_BROWSER_SHOW_TOOL_BAR, TRUE);
	EDV_SET_B(EDV_CFG_PARM_BROWSER_SHOW_LOCATION_BAR, TRUE);
	EDV_SET_B(EDV_CFG_PARM_BROWSER_SHOW_MOUNT_BAR, FALSE);
	EDV_SET_B(EDV_CFG_PARM_BROWSER_SHOW_FIND_BAR, FALSE);
	EDV_SET_B(EDV_CFG_PARM_BROWSER_SHOW_STATUS_BAR, TRUE);

	/* Tool Bar */
	glist = NULL;
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_GOTO_PARENT);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_GOTO_HOME);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_DIRECTORY_TREE_ORIGIN);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_REFRESH);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_MOVE);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_COPY);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_RENAME);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_DELETE);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_PROPERTIES);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_NEW_BROWSER);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_NEW_IMBR);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_RECYCLE_BIN);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INTLIST(EDV_CFG_PARM_BROWSER_TOOL_BAR, intlist);
	CFGIntListDelete(intlist);

	EDV_SET_I(
	    EDV_CFG_PARM_BROWSER_TOOL_BAR_DISPLAY,
	    (gint)TOOLBAR_DISPLAY_PICTURES_AND_TEXT
	);
	EDV_SET_I(
	    EDV_CFG_PARM_BROWSER_TOOL_BAR_RELIEF,
	    (gint)TOOLBAR_RELIEF_NONE
	);

	EDV_SET_S(EDV_CFG_PARM_BROWSER_DIR_TREE_ORIGIN, "/");

	EDV_SET_B(EDV_CFG_PARM_BROWSER_CONTENTS_HIDE_DIR_SIZE, FALSE);
	EDV_SET_B(EDV_CFG_PARM_BROWSER_CONTENTS_HIDE_LINK_PERMISSIONS, FALSE);

	/* Browser Contents Columns */
	glist = NULL;
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_COLUMN_TYPE_NAME);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_COLUMN_TYPE_SIZE);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_COLUMN_TYPE_TYPE);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_COLUMN_TYPE_PERMISSIONS);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_COLUMN_TYPE_OWNER);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_COLUMN_TYPE_GROUP);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_COLUMN_TYPE_DATE_MODIFIED);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_COLUMN_TYPE_HARD_LINKS);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_COLUMN_TYPE_LINKED_TO);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INTLIST(EDV_CFG_PARM_BROWSER_CONTENTS_COLUMN, intlist);
	CFGIntListDelete(intlist);

	/* Browser Contents Column Widths */
	glist = g_list_new_length(
	    EDV_BROWSER_CONTENTS_CLIST_COLUMNS_MAX,
	    (gpointer)0
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_NAME, (gpointer)150
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_SIZE, (gpointer)70
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_TYPE, (gpointer)100
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_PERMISSIONS, (gpointer)80
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_OWNER, (gpointer)80
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_GROUP, (gpointer)80
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_DATE_ACCESS, (gpointer)120
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_DATE_MODIFIED, (gpointer)120
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_DATE_CHANGED, (gpointer)120
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_HARD_LINKS, (gpointer)70
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_LINKED_TO, (gpointer)150
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_DEVICE, (gpointer)60
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_INODE, (gpointer)70
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_DEVICE_TYPE, (gpointer)90
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_BLOCK_SIZE, (gpointer)80
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_BLOCKS, (gpointer)60
	);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INTLIST(EDV_CFG_PARM_BROWSER_CONTENTS_COLUMN_WIDTH, intlist);
	CFGIntListDelete(intlist);

	/* Show Hidden Objects */
	EDV_SET_B(EDV_CFG_PARM_BROWSER_SHOW_OBJECT_HIDDEN, TRUE);
	/* Show No Access Objects */
	EDV_SET_B(EDV_CFG_PARM_BROWSER_SHOW_OBJECT_NOACCESS, TRUE);

	/* Accelerator Keys */
	ak_list = EDVBrowserAccelkeysListNewDefault();
	EDV_SET_ACCELKEY_LIST(EDV_CFG_PARM_BROWSER_ACCELERATOR_KEYS, ak_list);
	CFGAccelkeyListDelete(ak_list);


	/* Image Browser Geometry */
	EDV_SET_I(EDV_CFG_PARM_IMBR_X, 0);
	EDV_SET_I(EDV_CFG_PARM_IMBR_Y, 0);
	EDV_SET_I(EDV_CFG_PARM_IMBR_WIDTH, EDV_DEF_IMBR_WIDTH);
	EDV_SET_I(EDV_CFG_PARM_IMBR_HEIGHT, EDV_DEF_IMBR_HEIGHT);
	EDV_SET_I(
	    EDV_CFG_PARM_IMBR_PANED_POSITION,
	    EDV_DEF_IMBR_PANED_POSITION
	);

	EDV_SET_B(EDV_CFG_PARM_IMBR_SHOW_TOOL_BAR, TRUE);
	EDV_SET_B(EDV_CFG_PARM_IMBR_SHOW_LOCATION_BAR, TRUE);
	EDV_SET_B(EDV_CFG_PARM_IMBR_SHOW_MOUNT_BAR, FALSE);
	EDV_SET_B(EDV_CFG_PARM_IMBR_SHOW_FIND_BAR, FALSE);
	EDV_SET_B(EDV_CFG_PARM_IMBR_SHOW_STATUS_BAR, TRUE);

	/* Tool Bar */
	glist = NULL;
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_GOTO_PARENT);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_GOTO_HOME);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_REFRESH);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_MOVE);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_COPY);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_DELETE);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_PROPERTIES);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_STOP);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_CONTINUE);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_NEW_BROWSER);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_NEW_IMBR);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_RECYCLE_BIN);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INTLIST(EDV_CFG_PARM_IMBR_TOOL_BAR, intlist);
	CFGIntListDelete(intlist);

	EDV_SET_I(
	    EDV_CFG_PARM_IMBR_TOOL_BAR_DISPLAY,
	    (gint)TOOLBAR_DISPLAY_PICTURES_AND_TEXT
	);
	EDV_SET_I(
	    EDV_CFG_PARM_IMBR_TOOL_BAR_RELIEF,
	    (gint)TOOLBAR_RELIEF_NONE
	);

	color = CFGColorNew(0.0f, 0.0f, 0.0f, 1.0f);
	EDV_SET_COLOR(EDV_CFG_PARM_IMBR_COLOR_FG, color);
	CFGColorDelete(color);
	color = CFGColorNew(1.0f, 1.0f, 1.0f, 1.0f);
	EDV_SET_COLOR(EDV_CFG_PARM_IMBR_COLOR_BG, color);
	CFGColorDelete(color);
	color = CFGColorNew(0.0f, 0.0f, 0.0f, 1.0f);
	EDV_SET_COLOR(EDV_CFG_PARM_IMBR_COLOR_BORDER, color);
	CFGColorDelete(color);

	EDV_SET_B(EDV_CFG_PARM_IMBR_THUMB_LIST_HORIZONTAL, FALSE);
	EDV_SET_B(EDV_CFG_PARM_IMBR_THUMB_SHOW_FRAMES, TRUE);
	EDV_SET_B(EDV_CFG_PARM_IMBR_THUMB_SHOW_LABELS, TRUE);
	EDV_SET_I(EDV_CFG_PARM_IMBR_THUMB_WIDTH, DEF_IMBR_THUMB_WIDTH);
	EDV_SET_I(EDV_CFG_PARM_IMBR_THUMB_HEIGHT, DEF_IMBR_THUMB_HEIGHT);
	EDV_SET_I(EDV_CFG_PARM_IMBR_THUMB_BORDER, DEF_IMBR_THUMB_BORDER);
	EDV_SET_B(EDV_CFG_PARM_IMBR_THUMB_NO_ENLARGE, TRUE);

	/* Show Hidden Objects */
	EDV_SET_B(EDV_CFG_PARM_IMBR_SHOW_OBJECT_HIDDEN, TRUE);
	/* Show No Access Objects */
	EDV_SET_B(EDV_CFG_PARM_IMBR_SHOW_OBJECT_NOACCESS, TRUE);
	/* Show Non-Image Objects */
	EDV_SET_B(EDV_CFG_PARM_IMBR_SHOW_OBJECT_NONIMAGE, TRUE);

	/* Accelerator Keys */
	ak_list = EDVImbrAccelkeysListNewDefault();
	EDV_SET_ACCELKEY_LIST(EDV_CFG_PARM_IMBR_ACCELERATOR_KEYS, ak_list);
	CFGAccelkeyListDelete(ak_list);


	/* Image Browser Presentation Mode */
	EDV_SET_B(EDV_CFG_PARM_PRESENTATION_SHOW_NAVIGATOR, TRUE);
	EDV_SET_S(
	    EDV_CFG_PARM_PRESENTATION_FONT,
	    DEF_PRESENTATION_FONT
	);
	color = CFGColorNew(1.0f, 1.0f, 1.0f, 1.0f);
	EDV_SET_COLOR(EDV_CFG_PARM_PRESENTATION_COLOR_FG, color);
	CFGColorDelete(color);
	EDV_SET_B(EDV_CFG_PARM_PRESENTATION_COLOR_FG_INVERT, TRUE);
	color = CFGColorNew(0.0f, 0.0f, 0.5f, 1.0f);
	EDV_SET_COLOR(EDV_CFG_PARM_PRESENTATION_COLOR_BG, color);
	CFGColorDelete(color);                                   
	EDV_SET_I(EDV_CFG_PARM_PRESENTATION_HIDE_POINTER_DELAY, 3);
	EDV_SET_B(EDV_CFG_PARM_PRESENTATION_SLIDESHOW, FALSE);
	EDV_SET_I(EDV_CFG_PARM_PRESENTATION_SLIDESHOW_DELAY, 3);

	/* Archiver Geometry */
	EDV_SET_I(EDV_CFG_PARM_ARCHIVER_X, 0);
	EDV_SET_I(EDV_CFG_PARM_ARCHIVER_Y, 0);
	EDV_SET_I(EDV_CFG_PARM_ARCHIVER_WIDTH, EDV_DEF_ARCHIVER_WIDTH);
	EDV_SET_I(EDV_CFG_PARM_ARCHIVER_HEIGHT, EDV_DEF_ARCHIVER_HEIGHT);

	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_SHOW_ARCHIVE_INFO_ON_OPEN, TRUE);

	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_SHOW_TOOL_BAR, TRUE);
	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_SHOW_LOCATION_BAR, TRUE);
	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_SHOW_FIND_BAR, FALSE);
	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_SHOW_STATUS_BAR, TRUE);

	/* Tool Bar */
	glist = NULL;
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_OPEN);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_ADD);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_EXTRACT);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_EXTRACT_ALL);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_DELETE);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_REFRESH);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_COMMENT_AND_STATISTICS);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INTLIST(EDV_CFG_PARM_ARCHIVER_TOOL_BAR, intlist);
	CFGIntListDelete(intlist);

	EDV_SET_I(
	    EDV_CFG_PARM_ARCHIVER_TOOL_BAR_DISPLAY,
	    (gint)TOOLBAR_DISPLAY_PICTURES_AND_TEXT
	);
	EDV_SET_I(
	    EDV_CFG_PARM_ARCHIVER_TOOL_BAR_RELIEF,
	    (gint)TOOLBAR_RELIEF_NONE
	);

	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_CONTENTS_HIDE_DIR_SIZE, FALSE);
	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_CONTENTS_HIDE_LINK_PERMISSIONS, FALSE);

	/* Archiver Contents Columns */
	glist = NULL;
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_COLUMN_TYPE_NAME);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_COLUMN_TYPE_SIZE);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_COLUMN_TYPE_TYPE);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_COLUMN_TYPE_PERMISSIONS);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_COLUMN_TYPE_OWNER);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_COLUMN_TYPE_GROUP);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_COLUMN_TYPE_DATE_MODIFIED);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_COLUMN_TYPE_LINKED_TO);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INTLIST(EDV_CFG_PARM_ARCHIVER_CONTENTS_COLUMN, intlist);
	CFGIntListDelete(intlist);

	/* Archiver Contents Column Widths */
	glist = g_list_new_length(
	    EDV_ARCHIVER_CONTENTS_CLIST_COLUMNS_MAX,
	    (gpointer)0
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_NAME, (gpointer)150
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_SIZE, (gpointer)70
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_COMPRESSED_SIZE, (gpointer)70
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_TYPE, (gpointer)100
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_PERMISSIONS, (gpointer)80
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_OWNER, (gpointer)80
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_GROUP, (gpointer)80
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_DATE_ACCESS, (gpointer)120
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_DATE_MODIFIED, (gpointer)120
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_DATE_CHANGED, (gpointer)120
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_LOCATION, (gpointer)150
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_LINKED_TO, (gpointer)150
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_DEVICE_TYPE, (gpointer)90
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_COMPRESSION, (gpointer)80
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_METHOD, (gpointer)80
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_CRC, (gpointer)80
	);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INTLIST(EDV_CFG_PARM_ARCHIVER_CONTENTS_COLUMN_WIDTH, intlist);
	CFGIntListDelete(intlist);

	/* Accelerator Keys */
	ak_list = EDVArchiverAccelkeysListNewDefault();
	EDV_SET_ACCELKEY_LIST(EDV_CFG_PARM_ARCHIVER_ACCELERATOR_KEYS, ak_list);
	CFGAccelkeyListDelete(ak_list);


	/* Recycle Bin Geometry */
	EDV_SET_I(EDV_CFG_PARM_RECBIN_X, 0);
	EDV_SET_I(EDV_CFG_PARM_RECBIN_Y, 0);
	EDV_SET_I(EDV_CFG_PARM_RECBIN_WIDTH, EDV_DEF_RECBIN_WIDTH);
	EDV_SET_I(EDV_CFG_PARM_RECBIN_HEIGHT, EDV_DEF_RECBIN_HEIGHT);

	/* Recycle Bin Desktop Icon */
	EDV_SET_B(EDV_CFG_PARM_RECBIN_SHOW_DESKTOP_ICON, FALSE);
	EDV_SET_I(EDV_CFG_PARM_RECBIN_DESKTOP_ICON_X, 0);
	EDV_SET_I(EDV_CFG_PARM_RECBIN_DESKTOP_ICON_Y, 0);

	EDV_SET_B(EDV_CFG_PARM_RECBIN_SHOW_TOOL_BAR, TRUE);
	EDV_SET_B(EDV_CFG_PARM_RECBIN_SHOW_FIND_BAR, FALSE);
	EDV_SET_B(EDV_CFG_PARM_RECBIN_SHOW_STATUS_BAR, TRUE);

	/* Tool Bar */
	glist = NULL;
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_OP_RECOVER);
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_OP_PURGE);
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_OP_PURGE_ALL);
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_OP_REFRESH);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INTLIST(EDV_CFG_PARM_RECBIN_TOOL_BAR, intlist);
	CFGIntListDelete(intlist);

	EDV_SET_I(
	    EDV_CFG_PARM_RECBIN_TOOL_BAR_DISPLAY,
	    (gint)TOOLBAR_DISPLAY_PICTURES_AND_TEXT
	);
	EDV_SET_I(
	    EDV_CFG_PARM_RECBIN_TOOL_BAR_RELIEF,
	    (gint)TOOLBAR_RELIEF_NONE
	);

	EDV_SET_B(EDV_CFG_PARM_RECBIN_CONTENTS_HIDE_DIR_SIZE, FALSE);
	EDV_SET_B(EDV_CFG_PARM_RECBIN_CONTENTS_HIDE_LINK_PERMISSIONS, FALSE);

	/* Recycle Bin Contents Columns */
	glist = NULL;
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_COLUMN_TYPE_NAME);
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_COLUMN_TYPE_SIZE);
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_COLUMN_TYPE_TYPE);
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_COLUMN_TYPE_PERMISSIONS);
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_COLUMN_TYPE_OWNER);
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_COLUMN_TYPE_GROUP);
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_COLUMN_TYPE_ORIGINAL_LOCATION);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INTLIST(EDV_CFG_PARM_RECBIN_CONTENTS_COLUMN, intlist);
	CFGIntListDelete(intlist);

	/* Recycle Bin Contents Column Widths */
	glist = g_list_new_length(
	    EDV_RECBIN_CONTENTS_CLIST_COLUMNS_MAX,
	    (gpointer)0
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_NAME, (gpointer)150
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_SIZE, (gpointer)70
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_TYPE, (gpointer)100
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_PERMISSIONS, (gpointer)80
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_OWNER, (gpointer)80
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_GROUP, (gpointer)80
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_DATE_ACCESS, (gpointer)120
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_DATE_MODIFIED, (gpointer)120
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_DATE_CHANGED, (gpointer)120
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_DATE_DELETED, (gpointer)120
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_LINKED_TO, (gpointer)150
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_ORIGINAL_LOCATION, (gpointer)150
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_INDEX, (gpointer)60
	);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INTLIST(EDV_CFG_PARM_RECBIN_CONTENTS_COLUMN_WIDTH, intlist);
	CFGIntListDelete(intlist);

	/* Accelerator Keys */
	ak_list = EDVRecBinAccelkeysListNewDefault();
	EDV_SET_ACCELKEY_LIST(EDV_CFG_PARM_RECBIN_ACCELERATOR_KEYS, ak_list);
	CFGAccelkeyListDelete(ak_list);


	/* Find Window Geometry */
	EDV_SET_I(EDV_CFG_PARM_FINDWIN_X, 0);
	EDV_SET_I(EDV_CFG_PARM_FINDWIN_Y, 0);
	EDV_SET_I(EDV_CFG_PARM_FINDWIN_WIDTH, EDV_DEF_FINDWIN_WIDTH);
	EDV_SET_I(EDV_CFG_PARM_FINDWIN_HEIGHT, EDV_DEF_FINDWIN_HEIGHT);

	/* Find Window Search String */
	EDV_SET_S(EDV_CFG_PARM_FINDWIN_SEARCH_STRING, "");
	/* Find Window Operation */
	EDV_SET_I(
	    EDV_CFG_PARM_FINDWIN_FIND_OP,
	    (gint)EDV_FINDWIN_FIND_OBJECT_NAME
	);
	/* Find Window Case Sensitive */
	EDV_SET_B(EDV_CFG_PARM_FINDWIN_CASE_SENSITIVE, FALSE);
	/* Find Window Recursive */
	EDV_SET_B(EDV_CFG_PARM_FINDWIN_RECURSIVE, FALSE);


	/* Run Dialog Geometry */
	EDV_SET_I(EDV_CFG_PARM_RUNDLG_X, 0);
	EDV_SET_I(EDV_CFG_PARM_RUNDLG_Y, 0);

	/* Rin Dialog Run In Terminal */
	EDV_SET_B(EDV_CFG_PARM_RUNDLG_RUN_IN_TERMINAL, FALSE);
	/* Run Dialog Keep Dialog */
	EDV_SET_B(EDV_CFG_PARM_RUNDLG_KEEP_DIALOG, FALSE);
	/* Run Dialog Working Directory */
	EDV_SET_S(EDV_CFG_PARM_RUNDLG_LAST_WORKING_DIR, home_dir);


	g_free(startup_dir);
	g_free(tmp_dir);
	g_free(home_dir);
	g_free(global_data_dir);
	g_free(local_data_dir);
	g_free(global_config_dir);
}

/*
 *      Creates a standard list of cursors.
 */
static void EDVDoCreateStandardCursors(edv_core_struct *core_ptr)
{
	GdkWindow *root = GDK_ROOT_PARENT();
	GdkColor c_fg, c_bg;

#define APPEND_CURSOR(_cursor_)		{		\
 const gint i = MAX(core_ptr->total_cursors, 0);	\
 core_ptr->total_cursors = i + 1;			\
							\
 core_ptr->cursor = (edv_cursor_struct **)g_realloc(	\
  core_ptr->cursor,					\
  core_ptr->total_cursors * sizeof(edv_cursor_struct *)	\
 );							\
 if(core_ptr->cursor == NULL) {				\
  core_ptr->total_cursors = 0;				\
  EDVCursorDelete(_cursor_);				\
 } else {						\
  core_ptr->cursor[i] = (_cursor_);			\
 }							\
}
#define APPEND_CURSOR_PRESET(_code_,_gdk_type_)	{	\
 edv_cursor_struct *cursor = EDVCursorNewGDKPreset(	\
  (_code_), (_gdk_type_)				\
 );							\
 APPEND_CURSOR(cursor);					\
}
#define APPEND_CURSOR_PIXMAP(_code_,_cm_,_tm_,_hx_,_hy_) {	\
 APPEND_CURSOR(EDVCursorNew(				\
  (_code_),						\
  gdk_cursor_new_from_pixmap(				\
   (_cm_), (_tm_), &c_fg, &c_bg, (_hx_), (_hy_)		\
  )							\
 ));							\
}

	/* Set foreground and background colors */
	c_fg.red	= 0xffff;
	c_fg.green	= 0xffff;
	c_fg.blue	= 0xffff;
	c_bg.red	= 0x0000;
	c_bg.green	= 0x0000;
	c_bg.blue	= 0x0000;

	/* Begin creating cursors */

	if(FALSE)
	{
	    const gint width = 20, height = 20;
	    const gchar color_mask_data[] = {
0x00, 0x00, 0x00,
0xfe, 0x03, 0x00,
0x00, 0x00, 0x00,
0xfc, 0x01, 0x00,
0xfc, 0x01, 0x00,
0xac, 0x01, 0x00,
0xd8, 0x00, 0x00,
0x70, 0x00, 0x00,
0x20, 0x00, 0x00,
0x50, 0x00, 0x00,
0xf8, 0x00, 0x00,
0xdc, 0x01, 0x00,
0xac, 0x01, 0x00,
0x54, 0x01, 0x00,
0x00, 0x00, 0x00,
0xfe, 0x03, 0x00,
0x00, 0x00, 0x00,
0x00, 0x00, 0x00,
0x00, 0x00, 0x00,
0x00, 0x00, 0x00
	    };  
	    const gchar trans_mask_data[] = {
0xff, 0x07, 0x00,
0xff, 0x07, 0x00,
0xff, 0x07, 0x00,
0xfe, 0x03, 0x00,
0xfe, 0x03, 0x00,
0xfe, 0x03, 0x00,
0xfc, 0x01, 0x00,
0xf8, 0x00, 0x00,
0x70, 0x00, 0x00,
0xf8, 0x00, 0x00,
0xfc, 0x01, 0x00,
0xfe, 0x03, 0x00,
0xfe, 0x03, 0x00,
0xfe, 0x03, 0x00,
0xff, 0x07, 0x00,
0xff, 0x07, 0x00,
0xff, 0x07, 0x00,
0x00, 0x00, 0x00,
0x00, 0x00, 0x00,
0x00, 0x00, 0x00
	    };
	    GdkBitmap *color_mask = gdk_bitmap_create_from_data(
		root, color_mask_data, width, height
	    );
	    GdkBitmap *trans_mask = gdk_bitmap_create_from_data(
		root, trans_mask_data, width, height
	    );
	    APPEND_CURSOR_PIXMAP(
		EDV_CURSOR_CODE_BUSY,
		color_mask, trans_mask, 5, 8
	    );
	    GDK_BITMAP_UNREF(color_mask);
	    GDK_BITMAP_UNREF(trans_mask);
	}
	else
	{
	    APPEND_CURSOR_PRESET(EDV_CURSOR_CODE_BUSY, GDK_WATCH);
	}

	if(TRUE)
	{
	    const gint width = 24, height = 24;
	    const gchar color_mask_data[] = {
0x03, 0x00, 0x00,
0x05, 0x00, 0x00,
0x09, 0x00, 0x00,
0x11, 0x00, 0x00,
0x21, 0x00, 0x00,
0x41, 0x00, 0x00,
0x81, 0x00, 0x00,
0x01, 0x01, 0x00,
0x01, 0xc2, 0x7f,
0xc1, 0x03, 0x00,
0x49, 0x80, 0x3f,
0x95, 0x80, 0x3f,
0x93, 0x80, 0x35,
0x20, 0x01, 0x1b,
0x20, 0x01, 0x0e,
0xc0, 0x00, 0x04,
0x00, 0x00, 0x0a,
0x00, 0x00, 0x1f,
0x00, 0x80, 0x3b,
0x00, 0x80, 0x35,
0x00, 0x80, 0x2a,
0x00, 0x00, 0x00,
0x00, 0xc0, 0x7f,
0x00, 0x00, 0x00
	    };
	    const gchar trans_mask_data[] = {
0x03, 0x00, 0x00,
0x07, 0x00, 0x00,
0x0f, 0x00, 0x00,
0x1f, 0x00, 0x00,
0x3f, 0x00, 0x00,
0x7f, 0x00, 0x00,
0xff, 0x00, 0x00,
0xff, 0xe1, 0xff,
0xff, 0xe3, 0xff,
0xff, 0xe3, 0xff,
0x7f, 0xc0, 0x7f,
0xf7, 0xc0, 0x7f,
0xf3, 0xc0, 0x7f,
0xe0, 0x81, 0x3f,
0xe0, 0x01, 0x1f,
0xc0, 0x00, 0x0e,
0x00, 0x00, 0x1f,
0x00, 0x80, 0x3f,
0x00, 0xc0, 0x7f,
0x00, 0xc0, 0x7f,
0x00, 0xc0, 0x7f,
0x00, 0xe0, 0xff,
0x00, 0xe0, 0xff,
0x00, 0xe0, 0xff
	    };
	    GdkBitmap *color_mask = gdk_bitmap_create_from_data(
		root, color_mask_data, width, height
	    );   
	    GdkBitmap *trans_mask = gdk_bitmap_create_from_data(
		root, trans_mask_data, width, height
	    );
	    APPEND_CURSOR_PIXMAP(
		EDV_CURSOR_CODE_PASSIVE_BUSY,
		color_mask, trans_mask, 0, 0
	    );
	    GDK_BITMAP_UNREF(color_mask);
	    GDK_BITMAP_UNREF(trans_mask);
	}
	else
	{
	    APPEND_CURSOR_PRESET(EDV_CURSOR_CODE_BUSY, GDK_WATCH);
	}

	APPEND_CURSOR_PRESET(EDV_CURSOR_CODE_TEXT, GDK_XTERM);
	APPEND_CURSOR_PRESET(EDV_CURSOR_CODE_HAND, GDK_HAND2);
	APPEND_CURSOR_PRESET(EDV_CURSOR_CODE_TRANSLATE, GDK_FLEUR);
	APPEND_CURSOR_PRESET(EDV_CURSOR_CODE_RESIZE, GDK_SIZING);
	APPEND_CURSOR_PRESET(EDV_CURSOR_CODE_CROSSHAIR, GDK_TCROSS);

	if(TRUE)
	{
	    const gint width = 16, height = 16;
	    const gchar color_mask_data[] = {
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00
	    };
	    const gchar trans_mask_data[] = {
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00
	    };
	    GdkBitmap *color_mask = gdk_bitmap_create_from_data(
		root, color_mask_data, width, height
	    );
	    GdkBitmap *trans_mask = gdk_bitmap_create_from_data(
		root, trans_mask_data, width, height
	    );
	    APPEND_CURSOR_PIXMAP(
		EDV_CURSOR_CODE_INVISIBLE,
		color_mask, trans_mask, 0, 0
	    );
	    GDK_BITMAP_UNREF(color_mask);
	    GDK_BITMAP_UNREF(trans_mask);
	}


#undef APPEND_CURSOR_PRESET
#undef APPEND_CURSOR_PIXMAP
#undef APPEND_CURSOR
}


/*
 *	Allocates a new core structure, loads configuration, and creates 
 *	initial window(s).
 *
 *	If an InterPS lock link exists and reffers to an existing
 *	process then an InterPS will be sent to the reffered process.
 *
 *	err_rtn will be set appropriately, since returning NULL does
 *	not always indicate failure.
 */
edv_core_struct *EDVNew(gint argc, gchar *argv[], gint *err_rtn)
{
	gint i, p;
	const gchar *s, *arg;
	gboolean cfg_version_different;
	gint cfg_file_load_status;
	gint		old_version_major,
			old_version_minor,
			old_version_release;
	gboolean	no_splash = FALSE,
			startup_browser,
			startup_imbr,
			startup_archiver,
			startup_recbin;
	const gchar	*window_name = NULL,
			*arg_extra = NULL,
			*recycled_index_file,
			*alternate_config_file = NULL,
			*startup_dir = NULL;
	gchar		hostname[64 + 1];
	cfg_item_struct	*cfg_list;
	edv_core_struct *core_ptr = EDV_CORE(
	    g_malloc0(sizeof(edv_core_struct))
	);
	if(core_ptr == NULL)
	{
	    if(err_rtn != NULL)
		*err_rtn = -3;
	    return(core_ptr);
	}


	if(err_rtn != NULL)
	    *err_rtn = 0;


	/* Begin resetting values */
	core_ptr->cfg_file = NULL;
	core_ptr->cfg_list = NULL;

	core_ptr->pixmap_list = NULL;

	core_ptr->browser = NULL;
	core_ptr->total_browsers = 0;

	core_ptr->imbr = NULL;
	core_ptr->total_imbrs = 0;

	core_ptr->recbin = NULL;
	core_ptr->recbin_deskicon = NULL;
	core_ptr->last_recbin_items = 0;

	core_ptr->findwin = NULL;

	core_ptr->propdlg = NULL;
	core_ptr->total_propdlgs = 0;

	core_ptr->options_window = NULL;
	core_ptr->customize_window = NULL;

	core_ptr->about_dlg = NULL;

	core_ptr->geometry_set = FALSE;
	memset(&core_ptr->geometry, 0x00, sizeof(GdkRectangle));
	core_ptr->font_name = NULL;
	core_ptr->font = NULL;
	core_ptr->fg_color_name = NULL;
	core_ptr->bg_color_name = NULL;
	core_ptr->sfg_color_name = NULL;
	core_ptr->sbg_color_name = NULL;
	core_ptr->cfg_color_name = NULL;
	core_ptr->cbg_color_name = NULL;
	core_ptr->bg_pixmap_path = NULL;
	core_ptr->sbg_pixmap_path = NULL;
	core_ptr->wm_name = NULL;
	core_ptr->wm_class = NULL;
	core_ptr->title = NULL;

	core_ptr->standard_rcstyle = NULL;
	core_ptr->lists_rcstyle = NULL;

	core_ptr->manage_toid = 0;
	core_ptr->need_close_all_windows = FALSE;
	core_ptr->need_reset = FALSE;
	core_ptr->check_devices_toid = 0;

	core_ptr->interps_signal_count = 0;

	core_ptr->pid = getpid();
	core_ptr->prog_file = NULL;
	core_ptr->home_dir = STRDUP(g_getenv(ENV_VAR_NAME_HOME));

	core_ptr->user_id = getuid();
	core_ptr->effective_user_id = geteuid();
	core_ptr->group_id = getgid();
	core_ptr->effective_group_id = getegid();

	core_ptr->uid = NULL;
	core_ptr->total_uids = 0;
	core_ptr->users_pulist = NULL;
	core_ptr->gid = NULL;
	core_ptr->total_gids = 0;
	core_ptr->groups_pulist = NULL;

	core_ptr->effective_user_id_str = NULL;
	core_ptr->effective_user_id_host_str = NULL;

	core_ptr->cursor = NULL;
	core_ptr->total_cursors = 0;

	core_ptr->device = NULL;
	core_ptr->total_devices = 0;
	core_ptr->devices_pulist = NULL;

	core_ptr->mimetype = NULL;
	core_ptr->total_mimetypes = 0;
	core_ptr->openwith_pulist = NULL;
	core_ptr->mimetype_system_index_first = -1;
	core_ptr->mimetype_system_index_last = -1;
	core_ptr->mimetype_format_index_first = -1;
	core_ptr->mimetype_format_index_last = -1;
	core_ptr->mimetype_program_index_first = -1;
	core_ptr->mimetype_program_index_last = -1;
	core_ptr->mimetype_unique_index_first = -1;
	core_ptr->mimetype_unique_index_last = -1;


	/* Parse arguments */
	for(i = 1; i < argc; i++)
	{
	    arg = argv[i];
	    if(arg == NULL)
		continue;

	    /* Alternate configuration file? */
	    if(!g_strcasecmp(arg, "--config") ||
	       !g_strcasecmp(arg, "-config") ||
	       !g_strcasecmp(arg, "--rcfile") ||
	       !g_strcasecmp(arg, "-rcfile") ||
	       !g_strcasecmp(arg, "--f") ||
	       !g_strcasecmp(arg, "-f")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    alternate_config_file = arg;
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core_ptr, FALSE);
		    core_ptr = NULL;
		    if(err_rtn != NULL)
			*err_rtn = -2;
		    return(NULL);
		}
	    }
	    /* No splash? */
	    else if(!g_strcasecmp(arg, "--no-splash") ||
		    !g_strcasecmp(arg, "-no-splash") ||
		    !g_strcasecmp(arg, "--no_splash") ||
		    !g_strcasecmp(arg, "-no_splash")
	    )
	    {
		no_splash = TRUE;
	    }
	    /* Startup with File Browser? */
	    else if(!g_strcasecmp(arg, "--file_browser") ||
		    !g_strcasecmp(arg, "--file-browser") ||
		    !g_strcasecmp(arg, "-file_browser") ||
		    !g_strcasecmp(arg, "-file-browser") ||
		    !g_strcasecmp(arg, "--browser") ||
		    !g_strcasecmp(arg, "-browser")
	    )
	    {
		window_name = arg;
		while(*window_name == '-')
		    window_name++;
	    }
	    /* Startup with the image browser? */
	    else if(!g_strcasecmp(arg, "--image_browser") ||
		    !g_strcasecmp(arg, "--image-browser") ||
		    !g_strcasecmp(arg, "-image_browser") ||
		    !g_strcasecmp(arg, "-image-browser") ||
		    !g_strcasecmp(arg, "--imbr") ||
		    !g_strcasecmp(arg, "-imbr")
	    )
	    {
		window_name = arg;
		while(*window_name == '-')
		    window_name++;
	    }
	    /* Startup with the archiver? */
	    else if(!g_strcasecmp(arg, "--archiver") ||
		    !g_strcasecmp(arg, "-archiver")
	    )
	    {
		window_name = arg;
		while(*window_name == '-')
		    window_name++;
	    }
	    /* Startup with the recycle bin? */
	    else if(!g_strcasecmp(arg, "--recycle_bin") ||
		    !g_strcasecmp(arg, "--recycle-bin") ||
		    !g_strcasecmp(arg, "-recycle_bin") ||
		    !g_strcasecmp(arg, "-recycle-bin") ||
		    !g_strcasecmp(arg, "--recbin") ||
		    !g_strcasecmp(arg, "-recbin")
	    )
	    {
		window_name = arg;
		while(*window_name == '-')
		    window_name++;
	    }
	    /* Startup with the properties window? */
	    else if(!g_strcasecmp(arg, "--properties_dialog") ||
		    !g_strcasecmp(arg, "-properties_dialog") ||
		    !g_strcasecmp(arg, "--properties-dialog") ||
		    !g_strcasecmp(arg, "-properties-dialog") ||
		    !g_strcasecmp(arg, "--properties") ||
		    !g_strcasecmp(arg, "-properties") ||
		    !g_strcasecmp(arg, "--propdlg") ||
		    !g_strcasecmp(arg, "-propdlg")
	    )
	    {
		window_name = arg;
		while(*window_name == '-')
		    window_name++;
	    }
	    /* Startup with the options window? */
	    else if(!g_strcasecmp(arg, "--options") ||
		    !g_strcasecmp(arg, "-options")
	    )
	    {
		window_name = arg;
		while(*window_name == '-')
		    window_name++;
	    }
	    /* Startup with the customize window? */
	    else if(!g_strcasecmp(arg, "--customize") ||
		    !g_strcasecmp(arg, "-customize")
	    )
	    {
		window_name = arg;
		while(*window_name == '-')
		    window_name++;
	    }
	    /* Startup with the devices list? */
	    else if(!g_strcasecmp(arg, "--devices") ||
		    !g_strcasecmp(arg, "-devices")
	    )
	    {
		window_name = arg;
		while(*window_name == '-')
		    window_name++;
	    }
	    /* Startup with the mimetypes list? */
	    else if(!g_strcasecmp(arg, "--mimetypes") ||
		    !g_strcasecmp(arg, "-mimetypes")
	    )
	    {
		window_name = arg;
		while(*window_name == '-')
		    window_name++;
	    }
	    /* Startup with the run dialog? */
	    else if(!g_strcasecmp(arg, "--run_dialog") ||
		    !g_strcasecmp(arg, "--run-dialog") ||
		    !g_strcasecmp(arg, "-run_dialog") ||
		    !g_strcasecmp(arg, "-run-dialog") ||
		    !g_strcasecmp(arg, "--run_dlg") ||
		    !g_strcasecmp(arg, "--run-dlg") ||
		    !g_strcasecmp(arg, "-run_dlg") ||
		    !g_strcasecmp(arg, "-run-dlg") ||
		    !g_strcasecmp(arg, "--rundlg") ||
		    !g_strcasecmp(arg, "-rundlg")
	    )
	    {
		window_name = arg;
		while(*window_name == '-')
		    window_name++;
	    }
	    /* Startup with the about dialog? */
	    else if(!g_strcasecmp(arg, "--about_dialog") ||
		    !g_strcasecmp(arg, "--about-dialog") ||
		    !g_strcasecmp(arg, "-about_dialog") ||
		    !g_strcasecmp(arg, "-about-dialog") ||
		    !g_strcasecmp(arg, "--about_dlg") ||
		    !g_strcasecmp(arg, "--about-dlg") ||
		    !g_strcasecmp(arg, "-about_dlg") ||
		    !g_strcasecmp(arg, "-about-dlg") ||
		    !g_strcasecmp(arg, "--aboutdlg") ||
		    !g_strcasecmp(arg, "-aboutdlg")
	    )
	    {
		window_name = arg;
		while(*window_name == '-')
		    window_name++;
	    }

	    /* Geometry? */
	    else if(!g_strcasecmp(arg, "--geometry") ||
		    !g_strcasecmp(arg, "-geometry")
	    )
	    {
		i++;
		arg = (i < argc) ? argv[i] : NULL;
		if(!STRISEMPTY(arg))
		{
		    gint x, y, width, height;
		    GdkRectangle *rect = &core_ptr->geometry;
		    GdkGeometryFlags status = gdk_parse_geometry(
			arg, &x, &y, &width, &height
		    );
		    core_ptr->geometry_set = status ? TRUE : FALSE;
		    rect->x = (status & GDK_GEOMETRY_X) ? x : 0;
		    rect->y = (status & GDK_GEOMETRY_Y) ? y : 0;
		    rect->width = (status & GDK_GEOMETRY_WIDTH) ? width : 0;
		    rect->height = (status & GDK_GEOMETRY_HEIGHT) ? height : 0;
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			argv[i - 1]
		    );
		    EDVDelete(core_ptr, FALSE);
		    core_ptr = NULL;
		    if(err_rtn != NULL)
			*err_rtn = -2;
		    return(NULL);
		}		
	    }
	    /* Font name? */
	    else if(!g_strcasecmp(arg, "--font") ||
		    !g_strcasecmp(arg, "-font") ||
		    !g_strcasecmp(arg, "--fn") ||
		    !g_strcasecmp(arg, "-fn")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    g_free(core_ptr->font_name);
		    core_ptr->font_name = STRDUP(arg);
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core_ptr, FALSE);
		    core_ptr = NULL;
		    if(err_rtn != NULL)
			*err_rtn = -2;
		    return(NULL);
		}
	    }
	    /* Foreground color name? */
	    else if(!g_strcasecmp(arg, "--foreground") ||
		    !g_strcasecmp(arg, "-foreground") ||
		    !g_strcasecmp(arg, "--fg") ||
		    !g_strcasecmp(arg, "-fg")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    g_free(core_ptr->fg_color_name);
		    core_ptr->fg_color_name = STRDUP(arg);
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core_ptr, FALSE);
		    core_ptr = NULL;
		    if(err_rtn != NULL)
			*err_rtn = -2;
		    return(NULL);
		}
	    }
	    /* Background color name? */
	    else if(!g_strcasecmp(arg, "--background") ||
		    !g_strcasecmp(arg, "-background") ||
		    !g_strcasecmp(arg, "--bg") ||
		    !g_strcasecmp(arg, "-bg")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    g_free(core_ptr->bg_color_name);
		    core_ptr->bg_color_name = STRDUP(arg);
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core_ptr, FALSE);
		    core_ptr = NULL;
		    if(err_rtn != NULL)
			*err_rtn = -2;
		    return(NULL);
		}
	    }
	    /* Selected foreground color name? */
	    else if(!g_strcasecmp(arg, "--sforeground") ||
		    !g_strcasecmp(arg, "-sforeground") ||
		    !g_strcasecmp(arg, "--sfg") ||
		    !g_strcasecmp(arg, "-sfg")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    g_free(core_ptr->sfg_color_name);
		    core_ptr->sfg_color_name = STRDUP(arg);
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core_ptr, FALSE);
		    core_ptr = NULL;
		    if(err_rtn != NULL)
			*err_rtn = -2;
		    return(NULL);
		}
	    }
	    /* Selected background color name? */
	    else if(!g_strcasecmp(arg, "--sbackground") ||
		    !g_strcasecmp(arg, "-sbackground") ||
		    !g_strcasecmp(arg, "--sbg") ||
		    !g_strcasecmp(arg, "-sbg")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    g_free(core_ptr->sbg_color_name);
		    core_ptr->sbg_color_name = STRDUP(arg);
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core_ptr, FALSE);
		    core_ptr = NULL;
		    if(err_rtn != NULL)
			*err_rtn = -2;
		    return(NULL);
		}
	    }
	    /* Pointer cursor foreground color name? */
	    else if(!g_strcasecmp(arg, "--cforeground") ||
		    !g_strcasecmp(arg, "-cforeground") ||
		    !g_strcasecmp(arg, "--cfg") ||
		    !g_strcasecmp(arg, "-cfg")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    g_free(core_ptr->cfg_color_name);
		    core_ptr->cfg_color_name = STRDUP(arg);
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core_ptr, FALSE);
		    core_ptr = NULL;
		    if(err_rtn != NULL)
			*err_rtn = -2;
		    return(NULL);
		}
	    }
	    /* Pointer cursor background color name? */
	    else if(!g_strcasecmp(arg, "--cbackground") ||
		    !g_strcasecmp(arg, "-cbackground") ||
		    !g_strcasecmp(arg, "--cbg") ||
		    !g_strcasecmp(arg, "-cbg")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    g_free(core_ptr->cbg_color_name);
		    core_ptr->cbg_color_name = STRDUP(arg);
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core_ptr, FALSE);
		    core_ptr = NULL;
		    if(err_rtn != NULL)
			*err_rtn = -2;
		    return(NULL);
		}
	    }
	    /* Background pixmap path? */
	    else if(!g_strcasecmp(arg, "--background-pixmap") ||
		    !g_strcasecmp(arg, "-background-pixmap") ||
		    !g_strcasecmp(arg, "--bg-pixmap") ||
		    !g_strcasecmp(arg, "-bg-pixmap")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    g_free(core_ptr->bg_pixmap_path);
		    core_ptr->bg_pixmap_path = STRDUP(arg);
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core_ptr, FALSE);
		    core_ptr = NULL;
		    if(err_rtn != NULL)
			*err_rtn = -2;
		    return(NULL);
		}
	    }
	    /* Selected background pixmap path? */
	    else if(!g_strcasecmp(arg, "--sbackground-pixmap") ||
		    !g_strcasecmp(arg, "-sbackground-pixmap") ||
		    !g_strcasecmp(arg, "--sbg-pixmap") ||
		    !g_strcasecmp(arg, "-sbg-pixmap")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    g_free(core_ptr->sbg_pixmap_path);
		    core_ptr->sbg_pixmap_path = STRDUP(arg);
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core_ptr, FALSE);
		    core_ptr = NULL;
		    if(err_rtn != NULL)
			*err_rtn = -2;
		    return(NULL);
		}
	    }

	    /* Name? */
	    else if(!g_strcasecmp(arg, "--name") ||
		    !g_strcasecmp(arg, "-name")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    g_free(core_ptr->wm_name);
		    core_ptr->wm_name = STRDUP(arg);
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core_ptr, FALSE);
		    core_ptr = NULL;
		    if(err_rtn != NULL)
			*err_rtn = -2;
		    return(NULL);
		}
	    }
	    /* Class? */
	    else if(!g_strcasecmp(arg, "--class") ||
		    !g_strcasecmp(arg, "-class")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    g_free(core_ptr->wm_class);
		    core_ptr->wm_class = STRDUP(arg);
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core_ptr, FALSE);
		    core_ptr = NULL;
		    if(err_rtn != NULL)
			*err_rtn = -2;
		    return(NULL);
		}
	    }
	    /* Title? */
	    else if(!g_strcasecmp(arg, "--title") ||
		    !g_strcasecmp(arg, "-title")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    g_free(core_ptr->title);
		    core_ptr->title = STRDUP(arg);
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core_ptr, FALSE);
		    core_ptr = NULL;
		    if(err_rtn != NULL)
			*err_rtn = -2;
		    return(NULL);
		}
	    }
	    /* Alternate startup path? */
	    else if(g_path_is_absolute(arg))
	    {
		startup_dir = arg;
	    }
	    /* All else record as an extra argument */
	    else
	    {
		arg_extra = arg;
	    }
	}


	/* Record program file path from given arguments */
	if(argc > 0)
	{
	    g_free(core_ptr->prog_file);
	    core_ptr->prog_file = STRDUP(argv[0]);
	}

	/* Get the Host's Name */
	if(gethostname((char *)hostname, sizeof(hostname)))
	    *hostname = '\0';
	else
	    hostname[sizeof(hostname) - 1] = '\0';

	/* Get User & Group IDs */
	core_ptr->uid = EDVUIDGetSystem(&core_ptr->total_uids);
	core_ptr->gid = EDVGIDGetSystem(&core_ptr->total_gids);

	/* Get Effective User ID string */
	s = EDVUIDGetNameFromUID(
	    core_ptr->uid, core_ptr->total_uids,
	    core_ptr->effective_user_id, NULL
	);                                   
	g_free(core_ptr->effective_user_id_str);
	core_ptr->effective_user_id_str = STRDUP(
	    !STRISEMPTY(s) ? s : "anonymous"
	);

	/* Get Effective User ID & Hostname string */
	g_free(core_ptr->effective_user_id_host_str);
	core_ptr->effective_user_id_host_str = g_strdup_printf(
	    "%s@%s",
	    !STRISEMPTY(s) ? s : "anonymous",
	    !STRISEMPTY(hostname) ? hostname : "unknown"
	);

	/* Set up configuration list to default values */
	EDVDoCreateStandardConfiguration(core_ptr);
	cfg_list = core_ptr->cfg_list;

	/* Set configuration file path? */
	if(alternate_config_file != NULL)
	{
	    g_free(core_ptr->cfg_file);
	    core_ptr->cfg_file = STRDUP(alternate_config_file);
	}
	else
	{
	    /* Use standard configuration file in the local data
	     * directory
	     */
	    g_free(core_ptr->cfg_file);
	    core_ptr->cfg_file = STRDUP(PrefixPaths(
		EDV_GET_S(EDV_CFG_PARM_DIR_LOCAL),
		EDV_DEF_CONFIG_FILE
	    ));
	}
	/* Load configuration from file, overwriting any existing
	 * configuration values in the passed cfg_list
	 */
	cfg_file_load_status = CFGLoadFromFile(
	    core_ptr->cfg_file, cfg_list
	);


	/* Check if version obtained from configuration file is older than
	 * the compile time version of this program (include release version
	 * number in the check)
	 */
	old_version_major = EDV_GET_I(EDV_CFG_PARM_VERSION_MAJOR);
	old_version_minor = EDV_GET_I(EDV_CFG_PARM_VERSION_MINOR);
	old_version_release = EDV_GET_I(EDV_CFG_PARM_VERSION_RELEASE);

	/* Is version from configuration different than the compile time
	 * version?
	 */
	cfg_version_different = FALSE;
	if(old_version_major != PROG_VERSION_MAJOR)
	    cfg_version_different = TRUE;
	else if(old_version_minor != PROG_VERSION_MINOR)
	    cfg_version_different = TRUE;
	else if(old_version_release != PROG_VERSION_RELEASE)
	    cfg_version_different = TRUE;

	/* Now set the new version to the configuration since the
	 * version just fetched may be old
	 */
	EDV_SET_I(EDV_CFG_PARM_VERSION_MAJOR, PROG_VERSION_MAJOR);
	EDV_SET_I(EDV_CFG_PARM_VERSION_MINOR, PROG_VERSION_MINOR);
	EDV_SET_I(EDV_CFG_PARM_VERSION_RELEASE, PROG_VERSION_RELEASE);


	/* Override startup directory from command line? */
	if(startup_dir != NULL)
	    EDV_SET_S(EDV_CFG_PARM_DIR_START_UP, startup_dir);

	/* Get startup window options */
	startup_browser = EDV_GET_B(EDV_CFG_PARM_STARTUP_BROWSER);
	startup_imbr = EDV_GET_B(EDV_CFG_PARM_STARTUP_IMBR);
	startup_archiver = EDV_GET_B(EDV_CFG_PARM_STARTUP_ARCHIVER);
	startup_recbin = EDV_GET_B(EDV_CFG_PARM_STARTUP_RECBIN);


	/* Check if the InterPS lock link exists, the process is
	 * actually already running, and it is not this process
	 *
	 * Note that EDVInterPSGetLock() will only return non-zero if
	 * the process indicated by the lock link is actually running
	 */
	p = EDVInterPSGetLock(cfg_list);
	if((p != 0) && (p != core_ptr->pid))
	{
	    /* Issue a command to the already running process */
	    gchar *cmd, *cmdv[1];

	    /* If no window name was specified at startup, then
	     * use the one specified from the configuration
	     */
	    if(STRISEMPTY(window_name))
	    {
		if(startup_browser)
		    window_name = "file_browser";
		else if(startup_imbr)
		    window_name = "image_browser";
		else if(startup_archiver)
		    window_name = "archiver";
		else if(startup_recbin)
		    window_name = "recycle_bin";
		else
		    window_name = "file_browser";
	    }

	    /* Format a command, specifying to create a new window and
	     * send that command to the already running process
	     */
	    cmdv[0] = cmd = g_strdup_printf(
		"new_window \"%s\" \"%s\" \"%s\"",
		window_name,
		(startup_dir != NULL) ? startup_dir : "",
		(arg_extra != NULL) ? arg_extra : ""
	    );
	    EDVInterPSSendCommand(cfg_list, p, cmdv, 1);
	    g_free(cmd);

	    EDVDelete(core_ptr, FALSE);
	    return(NULL);
	}

	/* (Re)create InterPS lock link and remove any queued
	 * interprocess commands
	 */
	EDVInterPSMakeLock(cfg_list, core_ptr->pid, TRUE);
	EDVInterPSRemoveCommand(cfg_list);


	/* Get path of recycled object index file */
	recycled_index_file = EDV_GET_S(EDV_CFG_PARM_FILE_RECYCLED_INDEX);
	/* Update number of recycled objects on the core structure */
	core_ptr->last_recbin_items = EDVRecBinFIOTotalItems(
	    recycled_index_file
	);

	/* Load default font if specified */
	if(!STRISEMPTY(core_ptr->font_name))
	{
	    core_ptr->font = gdk_font_load(core_ptr->font_name);
	}

	/* Create RC styles */
	EDVUpdateRCStyles(core_ptr);

	/* Update global tooltips state */
	GUISetGlobalTipsState(EDV_GET_B(EDV_CFG_PARM_SHOW_TOOLTIPS));

	/* Create standard cursors */
	EDVDoCreateStandardCursors(core_ptr);




	/* Open devices from the system, then open devices from the
	 * local devices file
	 */
	EDVDevicesListLoadFromSystem(
	    &core_ptr->device, &core_ptr->total_devices,
	    NULL, core_ptr
	);
	EDVDevicesListLoadFromFile(
	    EDV_GET_S(EDV_CFG_PARM_FILE_DEVICES),
	    &core_ptr->device, &core_ptr->total_devices,
	    NULL, core_ptr
	);
	/* Get device mount states & stats */
	EDVDevicesListUpdateMountStates(
	    core_ptr->device, core_ptr->total_devices
	);
	EDVDevicesListUpdateStats(
	    core_ptr->device, core_ptr->total_devices
	);


	/* Open MIME Types from the system, then open MIME Types
	 * from the local & global MIME Types files.
	 */
	EDVDMimeTypesListLoadFromSystem(
	    &core_ptr->mimetype, &core_ptr->total_mimetypes,
	    -1,			/* Append */
	    NULL, core_ptr,
	    NULL, core_ptr,
	    TRUE		/* Read only */
	);
	EDVMimeTypeListLoadFromFile(
	    EDV_GET_S(EDV_CFG_PARM_FILE_MIME_TYPES),
	    &core_ptr->mimetype, &core_ptr->total_mimetypes,
	    -1,			/* Append */
	    FALSE, FALSE,
	    NULL, core_ptr,
	    NULL, core_ptr,
	    FALSE		/* Not read only */
	);
	EDVMimeTypeListLoadFromFile(
	    EDV_GET_S(EDV_CFG_PARM_FILE_MIME_TYPES_GLOBAL),
	    &core_ptr->mimetype, &core_ptr->total_mimetypes,
	    -1,			/* Append */
	    FALSE, FALSE,
	    NULL, core_ptr,
	    NULL, core_ptr,
	    TRUE		/* Read only */
	);
	/* Update MIME Types class list index hints */
	EDVUpdateMIMETypeHintIndices(core_ptr);


	/* Create Users & Groups Popup Lists */
	EDVUpdateIDPULists(core_ptr);

	/* Create the Devices Popup List */
	EDVUpdateDevicesPUList(core_ptr);

	/* Create the Open With Popup List */
	EDVUpdateOpenWithPUList(core_ptr);


	/* If the configuration file version is different from the
	 * compile time version of this program, then, print warning at
	 * this point
	 */
	if(cfg_version_different)
	{
	    gchar *buf = g_strdup_printf(
#if defined(PROG_LANGUAGE_SPANISH)
"%s ha cambiado de la versin %i.%i.%i a la versin %s.\n\
\n\
Los valores de la configuracin pueden haber cambiado desde que\n\
la versin previa, usted debe tomar un momento de revisar sus\n\
opciones y las personalizaciones yendo a Escenarios->Opciones...\n\
y Escenarios->Personaliza...\n"
#elif defined(PROG_LANGUAGE_FRENCH)
"%s a chang de %i.%i.%i de version  %s de version.\n\
\n\
Les valeurs de configuration ont pu changer puisque la version\n\
prcdente, vous devez prendre un moment pour rexaminer vos\n\
options et vos personnalisations en allant aux\n\
Montages->Options... et les Montages->Personnalise...\n"
#elif defined(PROG_LANGUAGE_GERMAN)
"%s hat von Version %i.%i.%i zu Version %s gendert.\n\
\n\
Die konfiguration werte knnen gendert haben, da die vorherige\n\
version, sie einen moment nehmen sollen, ihre optionen und\n\
anpassungen durch gehen zu Settings->Optionen... und\n\
Settings->Anpassungen...\n"
#elif defined(PROG_LANGUAGE_ITALIAN)
"%s ha cambiato da %i.%i.%i di versione a %s di versione.\n\
\n\
I valori di configurazione possono avere cambiato poich la\n\
versione precedente, lei dovrebbe portare un momento a riesaminare\n\
le sue opzioni e le sue personalizzazioni da andare ai\n\
Montaggi->Opzioni... ed i Montaggi->Personalizza...\n"
#elif defined(PROG_LANGUAGE_DUTCH)
"%s heeft van uitvoering %i.%i.%i aan uitvoering %s veranderd.\n\
\n\
De configuratie waarde hebben misschien veranderd aangezien de\n\
vorige uitvoering, u een moment zou moeten nemen om opnieuw je\n\
opties en aanpassingen door gaan aan Settings->Opties... en\n\
Settings->Aanpassingen...\n"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"%s mudou de %i.%i.%i de verso a %s de verso.\n\
\n\
Os valores de configurao podem ter mudado desde que a verso\n\
prvia, voc devem tomar um momento revisar seuas opes e\n\
customizations por ir a Settings->Opes... e\n\
Settings->Customizations...\n"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"%s forandrer seg fra versjon %i.%i.%i til versjon %s.\n\
\n\
Konfigurasjonsverdiene forandret seg da den forrige versjonen,\n\
de tar et yeblikk overprve Deres alternativer og customizations\n\
ved  dra til Innstillinger->Alternativer... og\n\
Innstillinger->Customizations...\n"
#else
"%s has changed from version %i.%i.%i to version %s.\n\
\n\
The configuration values may have changed since the previous version,\n\
you should take a moment to review your options and customizations\n\
by going to Settings->Options... and Settings->Customize...\n"
#endif
		, PROG_NAME_FULL,
		old_version_major, old_version_minor, old_version_release,
		PROG_VERSION
	    );

	    EDVPlaySoundInfo(core_ptr);
	    CDialogSetTransientFor(NULL);
	    CDialogGetResponse(
#if defined(PROG_LANGUAGE_SPANISH)
"La Nota Del Cambio De La Versin"
#elif defined(PROG_LANGUAGE_FRENCH)
"La Notification De Changement De Version"
#elif defined(PROG_LANGUAGE_GERMAN)
"Version nderung Notiz"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Avviso Di Cambiamento Di Versione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Uitvoering Verandering Bericht"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Aviso De Mudana De Verso"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"VersjonsForandring Legger Merke Til"
#else
"Version Change Notice"
#endif

		, buf, NULL,
		CDIALOG_ICON_INSTALL,
		CDIALOG_BTNFLAG_OK,
		CDIALOG_BTNFLAG_OK
	    );
	    CDialogSetTransientFor(NULL);
	    g_free(buf);
	}


	/* Check Recycle Bin size and warn user as needed */
	EDVRecycleBinSizeCheck(core_ptr, NULL);


	/* Map Recycle Bin Desktop Icon? */
	if(EDV_GET_B(EDV_CFG_PARM_RECBIN_SHOW_DESKTOP_ICON))
	    EDVMapRecBinDeskIcon(core_ptr);


	/* Begin creating initial window, check if no window was
	 * specified from the command line
	 */
	if(STRISEMPTY(window_name))
	{
	    /* No window name specified so startup with a window
	     * specified by the configuration
	     */
	    gboolean created_window = FALSE;

	    if(startup_browser)
	    {
		EDVNewBrowser(core_ptr);
		created_window = TRUE;
	    }
	    if(startup_imbr)
	    {
		EDVNewImbr(core_ptr);
		created_window = TRUE;
	    }
	    if(startup_archiver)
	    {
		EDVNewArchiverOpen(core_ptr, startup_dir);
		created_window = TRUE;
	    }
	    if(startup_recbin)
	    {
		EDVMapRecBin(core_ptr);
		created_window = TRUE;
	    }
	    /* If no window was specified to be created then create a
	     * File Browser
	     */
	    if(!created_window)
	    {
		EDVNewBrowser(core_ptr);
		created_window = TRUE;
	    }
	}
	else
	{
	    /* Create a window specified by the command line */
	    EDVNewWindowNexus(
		core_ptr, window_name, startup_dir, arg_extra, NULL
	    );
	}

#if !defined(DEBIAN)
	/* Display License/Copyright?
	 *
	 * Use the About dialog to display the copyright if the version
	 * has changed or there was an error loading the configuration
	 * file (suggesting the configuration file does not exist)
	 */
	if(cfg_version_different || cfg_file_load_status)
	    EDVAboutPage(
		core_ptr, "Copyright", NULL
	    );
#endif

	/* Set main management timeout function */
	core_ptr->manage_toid = gtk_timeout_add(
	    1000l, 		/* 1 second interval */
	    EDVManageTimeoutCB, core_ptr
	);

	return(core_ptr);
}

/*
 *	Saves the configuration on the specified core (if save_config
 *	is TRUE) and then deletes the core.
 */
void EDVDelete(edv_core_struct *core_ptr, gboolean save_config)
{
	gint i;

	if(core_ptr == NULL)
	    return;

	/* Save configuration only if the core structure's configuration
	 * list is defined and we have been specifically told to save
	 */
	if((core_ptr->cfg_list != NULL) && save_config)
	{
	    const cfg_item_struct *cfg_list = core_ptr->cfg_list;

	    /* Save MIME Types */
	    EDVMimeTypeListSaveToFile(
		EDV_GET_S(EDV_CFG_PARM_FILE_MIME_TYPES),
		core_ptr->mimetype, core_ptr->total_mimetypes,
		FALSE,		/* Do not save MIME Types marked read_only */
		NULL, core_ptr
	    );

	    /* Save Devices */
	    EDVDeviceListSaveToFile(
		EDV_GET_S(EDV_CFG_PARM_FILE_DEVICES),
		core_ptr->device, core_ptr->total_devices,
		NULL, core_ptr
	    );

	    /* Save configuration */
	    CFGSaveToFile(core_ptr->cfg_file, core_ptr->cfg_list);
	}


	/* Remove InterPS lock link if it refers to this process */
	if(EDVInterPSGetLock(core_ptr->cfg_list) == core_ptr->pid)
	    EDVInterPSRemoveLock(core_ptr->cfg_list);


	/* Begin deleting resources */

	/* Remove timeouts callbacks */
	GTK_TIMEOUT_REMOVE(core_ptr->check_devices_toid);
	core_ptr->check_devices_toid = 0;
	GTK_TIMEOUT_REMOVE(core_ptr->manage_toid);
	core_ptr->manage_toid = 0;

	/* Delete all Property Dialogs */
	for(i = 0; i < core_ptr->total_propdlgs; i++)
	    EDVPropDlgDelete(core_ptr->propdlg[i]);
	g_free(core_ptr->propdlg);
	core_ptr->propdlg = NULL;
	core_ptr->total_propdlgs = 0;

	/* Delete all File Browsers */
	for(i = 0; i < core_ptr->total_browsers; i++)
	    EDVBrowserDelete(core_ptr->browser[i]);
	g_free(core_ptr->browser);
	core_ptr->browser = NULL;
	core_ptr->total_browsers = 0;

	/* Delete all Image Browsers */
	for(i = 0; i < core_ptr->total_imbrs; i++)
	    EDVImbrDelete(core_ptr->imbr[i]);
	g_free(core_ptr->imbr);
	core_ptr->imbr = NULL;
	core_ptr->total_imbrs = 0;

	/* Delete Recycle Bin */
	EDVRecBinDelete(core_ptr->recbin);
	core_ptr->recbin = NULL;

	/* Delete Recycle Bin desktop icon */
	EDVRecBinDeskIconDelete(core_ptr->recbin_deskicon);
	core_ptr->recbin_deskicon = NULL;

	/* Delete Find Window */
	EDVFindWinDelete(core_ptr->findwin);
	core_ptr->findwin = NULL;


	/* Delete History List Window */
	EDVHistoryListWinDelete(core_ptr->history_listwin);
	core_ptr->history_listwin = NULL;

	/* Delete Run Dialog */
	EDVRunDlgDelete(core_ptr->run_dlg);
	core_ptr->run_dlg = NULL;

	/* Delete Devices List Window */
	EDVDevicesListWinDelete(core_ptr->device_listwin);
	core_ptr->device_listwin = NULL;

	/* Delete MIME Types List Window */
	EDVMimeTypesListWinDelete(core_ptr->mimetype_listwin);
	core_ptr->mimetype_listwin = NULL;

	/* Delete Options Window */
	OptWinDelete(core_ptr->options_window);
	core_ptr->options_window = NULL;

	/* Delete Customize Window */
	OptWinDelete(core_ptr->customize_window);
	core_ptr->customize_window = NULL;

	/* Delete About Dialog */
	AboutDlgDelete(core_ptr->about_dlg);
	core_ptr->about_dlg = NULL;



	/* Delete Open With popup list widget */
	PUListDelete(core_ptr->openwith_pulist);
	core_ptr->openwith_pulist = NULL;

	/* Delete all MIME Types */
	for(i = 0; i < core_ptr->total_mimetypes; i++)
	    EDVMimeTypeDelete(core_ptr->mimetype[i]);
	g_free(core_ptr->mimetype);
	core_ptr->mimetype = NULL;
	core_ptr->total_mimetypes = 0;


	/* Delete the Devices Popup List */
	PUListDelete(core_ptr->devices_pulist);
	core_ptr->devices_pulist = NULL;

	/* Delete all Devices */
	for(i = 0; i < core_ptr->total_devices; i++)
	    EDVDeviceDelete(core_ptr->device[i]);
	g_free(core_ptr->device);
	core_ptr->device = NULL;
	core_ptr->total_devices = 0;

	/* Delete all Cursors */
	for(i = 0; i < core_ptr->total_cursors; i++)
	    EDVCursorDelete(core_ptr->cursor[i]);
	g_free(core_ptr->cursor);
	core_ptr->cursor = NULL;
	core_ptr->total_cursors = 0;


	/* Delete the configuration list */
	CFGItemListDeleteList(core_ptr->cfg_list);
	core_ptr->cfg_list = NULL;


	/* Delete the Users & Groups Popup Lists */
	PUListDelete(core_ptr->users_pulist);
	core_ptr->users_pulist = NULL;
	PUListDelete(core_ptr->groups_pulist);
	core_ptr->groups_pulist = NULL;

	/* Delete User & Group IDs */
	for(i = 0; i < core_ptr->total_uids; i++)
	    EDVUIDDelete(core_ptr->uid[i]);
	g_free(core_ptr->uid);
	core_ptr->uid = NULL;
	core_ptr->total_uids = 0;

	for(i = 0; i < core_ptr->total_gids; i++)
	    EDVGIDDelete(core_ptr->gid[i]);
	g_free(core_ptr->gid);
	core_ptr->gid = NULL;
	core_ptr->total_gids = 0;


	/* Reset the DND Icon */
	GUIDNDSetDragIcon(NULL, NULL, 0, 0);


	/* Delete user defined GtkRcStyles */
	GTK_RC_STYLE_UNREF(core_ptr->standard_rcstyle)
	core_ptr->standard_rcstyle = NULL;
	GTK_RC_STYLE_UNREF(core_ptr->lists_rcstyle)
	core_ptr->lists_rcstyle = NULL;


	/* Delete the Pixmaps List */
	core_ptr->pixmap_list = EDVPixmapListClean(core_ptr->pixmap_list);
	g_list_foreach(
	    core_ptr->pixmap_list, (GFunc)EDVPixmapDelete, NULL
	);
	g_list_free(core_ptr->pixmap_list);
	core_ptr->pixmap_list = NULL;


	/* Delete other memory on the core */
	core_ptr->geometry_set = FALSE;
	memset(&core_ptr->geometry, 0x00, sizeof(GdkRectangle));

	g_free(core_ptr->font_name);
	core_ptr->font_name = NULL;

	if(core_ptr->font != NULL)
	{
	    gdk_font_unref(core_ptr->font);
	    core_ptr->font = NULL;
	}

	g_free(core_ptr->fg_color_name);
	core_ptr->fg_color_name = NULL;
	g_free(core_ptr->bg_color_name);
	core_ptr->bg_color_name = NULL;

	g_free(core_ptr->sfg_color_name);
	core_ptr->sfg_color_name = NULL;
	g_free(core_ptr->sbg_color_name);
	core_ptr->sbg_color_name = NULL;

	g_free(core_ptr->cfg_color_name);
	core_ptr->cfg_color_name = NULL;
	g_free(core_ptr->cbg_color_name);
	core_ptr->cbg_color_name = NULL;

	g_free(core_ptr->bg_pixmap_path);
	core_ptr->bg_pixmap_path = NULL;
	g_free(core_ptr->sbg_pixmap_path);
	core_ptr->sbg_pixmap_path = NULL;

	g_free(core_ptr->wm_name);
	core_ptr->wm_name = NULL;
	g_free(core_ptr->wm_class);
	core_ptr->wm_class = NULL;
	g_free(core_ptr->title);
	core_ptr->title = NULL;


	g_free(core_ptr->cfg_file);
	core_ptr->cfg_file = NULL;

	core_ptr->interps_signal_count = 0;

	g_free(core_ptr->prog_file);
	core_ptr->prog_file = NULL;

	g_free(core_ptr->home_dir);
	core_ptr->home_dir = NULL;

	g_free(core_ptr->effective_user_id_str);
	core_ptr->effective_user_id_str = NULL;
	g_free(core_ptr->effective_user_id_host_str);
	core_ptr->effective_user_id_host_str = NULL;

	g_free(core_ptr);
}
