/*
                          History List Window
 */

#ifndef HISTORYWIN_H
#define HISTORYWIN_H

#include <gtk/gtk.h>
#include "edvtypes.h"
#include "edvhistory.h"


/*
 *	History List Window Cell Styles:
 */
typedef enum {
	EDV_HISTORY_CELL_STYLE_SUCCESS,
	EDV_HISTORY_CELL_STYLE_ERROR,		/* General/system/ambiguous */
	EDV_HISTORY_CELL_STYLE_CANCEL		/* Cancel/no/abort */
} edv_history_listwin_cell_style;
#define EDV_HISTORY_TOTAL_CELL_STYLES	3


/*
 *	History List Window:
 */
typedef struct {

        GtkWidget	*toplevel;
        GtkAccelGroup	*accelgrp;
        gboolean	processing;
        gint		busy_count,
			freeze_count;
        gpointer	core_ptr;

	GtkWidget	*main_vbox,
			*find_entry,
			*history_clist,
			*refresh_btn,
			*save_as_btn,
			*clear_btn,
			*display_parent,	/* GtkVBox */
			*display_client,	/* Parented to display_parent */
			*close_btn;

	/* Right click menu */
	GtkWidget	*menu,
			*refresh_mi,
			*save_as_mi,
			*clear_mi;

	/* Pixmap and mask pairs used for operation icons */
	GdkPixmap	*other_operation_pixmap;
	GdkBitmap	*other_operation_mask;

	GdkPixmap	*object_create_pixmap;
	GdkBitmap	*object_create_mask;
	GdkPixmap	*object_copy_pixmap;
	GdkBitmap	*object_copy_mask;
	GdkPixmap	*object_move_pixmap;
	GdkBitmap	*object_move_mask;
	GdkPixmap	*object_link_pixmap;
	GdkBitmap	*object_link_mask;
	GdkPixmap	*object_chown_pixmap;
	GdkBitmap	*object_chown_mask;
	GdkPixmap	*object_chmod_pixmap;
	GdkBitmap	*object_chmod_mask;
	GdkPixmap	*object_date_pixmap;
	GdkBitmap	*object_date_mask;
	GdkPixmap	*object_download_pixmap;
	GdkBitmap	*object_download_mask;
	GdkPixmap	*object_delete_pixmap;
	GdkBitmap	*object_delete_mask;

	GdkPixmap	*recobj_recover_pixmap;
	GdkBitmap	*recobj_recover_mask;
	GdkPixmap	*recobj_purge_pixmap;
	GdkBitmap	*recobj_purge_mask;

	GdkPixmap	*arcobj_add_pixmap;
	GdkBitmap	*arcobj_add_mask;
	GdkPixmap	*arcobj_extract_pixmap;
	GdkBitmap	*arcobj_extract_mask;
	GdkPixmap	*arcobj_delete_pixmap;
	GdkBitmap	*arcobj_delete_mask;

	GdkPixmap	*object_other_small_pixmap;
	GdkBitmap	*object_other_small_mask;
	GdkPixmap	*object_other_medium_pixmap;
	GdkBitmap	*object_other_medium_mask;

	GdkPixmap	*error_small_pixmap;
	GdkBitmap	*error_small_mask;
	GdkPixmap	*error_medium_pixmap;
	GdkBitmap	*error_medium_mask;

	/* Styles for directory_ctree and contents_clist cells */
	GtkStyle	*cell_style[EDV_HISTORY_TOTAL_CELL_STYLES];

} edv_history_listwin_struct;
#define EDV_HISTORY_LISTWIN(p)	((edv_history_listwin_struct *)(p))


/* In historywin.c */
extern void EDVHistoryListWinWriteProtectChangedCB(
	edv_history_listwin_struct *lw, gboolean state
);
extern void EDVHistoryListWinHistoryAddedCB(
	edv_history_listwin_struct *lw,
	gint h_num, const edv_history_struct *h_ptr
);
extern void EDVHistoryListWinHistoryRemovedCB(
	edv_history_listwin_struct *lw,
	gint h_num
);
extern void EDVHistoryListWinReconfiguredNotifyCB(
	edv_history_listwin_struct *lw
);

extern void EDVHistoryListWinClear(edv_history_listwin_struct *lw);
extern void EDVHistoryListWinSaveAs(edv_history_listwin_struct *lw);

extern void EDVHistoryListWinUpdateDisplay(
	edv_history_listwin_struct *lw,
	const edv_history_struct *h_ptr
);
extern void EDVHistoryListWinUpdateList(
	edv_history_listwin_struct *lw
);

extern void EDVHistoryListWinSyncConfiguration(
	edv_history_listwin_struct *lw
);

extern void EDVHistoryListWinListStylesRegenerate(
	edv_history_listwin_struct *lw
);

extern edv_history_listwin_struct *EDVHistoryListWinNew(
	gpointer core_ptr
);
extern void EDVHistoryListWinUpdateMenus(edv_history_listwin_struct *lw);
extern void EDVHistoryListWinSetBusy(
	edv_history_listwin_struct *lw, gboolean is_busy
);
extern gboolean EDVHistoryListWinIsMapped(edv_history_listwin_struct *lw);
extern void EDVHistoryListWinMap(edv_history_listwin_struct *lw);
extern void EDVHistoryListWinUnmap(edv_history_listwin_struct *lw);
extern void EDVHistoryListWinDelete(edv_history_listwin_struct *lw);


#endif	/* HISTORYWIN_H */
