#include <stdlib.h>
#include <stdio.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>
#include <errno.h>



/* Defind INADDR_NONE for systems(solaris) that don't fully support sockets. */
#ifndef INADDR_NONE
#define INADDR_NONE -1
#endif /* INADDR_NONE */


/* We pull a bit of data out of argv here.  argv[1] is the flag, either -i
 * or -h depending on whether we're outputting an ip or a hostname. */
int
main (int argc, char **argv)
{
    if (argc != 3) {
	printf ("Not the right number of arguments to the resolver\n");
        return EXIT_FAILURE;
    }

    if (0 == strcmp (argv[1], "-i")) {
        struct hostent *host;
        struct in_addr addr;


        host = gethostbyname (argv[2]);
        if (NULL == host) {
            printf ("ERROR: system errno is %i, '%s'\n",
		errno, strerror(errno));
            return EXIT_FAILURE;
	}

        memcpy ((void*)&addr, host->h_addr, host->h_length);
        printf ("%s\n", inet_ntoa(addr));
        return EXIT_SUCCESS;
    } else if (0 == strcmp (argv[1], "-h")) {
        struct hostent *host;
	unsigned long address_as_int;

	/* INADDR_NONE is failure from inet_addr(). */
	address_as_int = inet_addr (argv[2]);
	if (INADDR_NONE == address_as_int) {
            printf ("ERROR: invalid ip address\n");
            return EXIT_FAILURE;
        }

        host = gethostbyaddr ((char *)&address_as_int,
		sizeof (address_as_int), AF_INET);
	if (NULL == host) {
            printf ("ERROR: system errno is %i, '%s'\n",
		errno, strerror(errno));

	    return EXIT_FAILURE;
	}

        printf ("%s\n", host->h_name);
        return EXIT_SUCCESS;
    }

    printf ("'%s' wasn't -i or -h\n", argv[1]);
    return EXIT_FAILURE;
}

