#!/usr/bin/env entity
<object>

  <data name="README">
This is a test of the style="" attribute.  

Note:
the label="" creates a gtk label widget.  We pass
on the style="" to that label widget.

Author(s): Matt Wimer
  </data>

  <window title="Style/Color Test" ondelete="entity:exit">
    <button style="bg[normal]=yellow,bg[prelight]=green">
      <label text="hello" style="fg[normal]=red" />
    </button>
    <button label="hello" style="fg[normal]=orange" onclick="revert"/>

    <text style="base[normal]=gray,
		font[normal]=blue,
		bg[sel]=green,
		fg[sel]=orange"
          editable="true">TEXT HERE</text>

    <tree style="fg[sel]=pink" expand="true">
      <tree label="level 1" >
        <tree label="1 ip" style="fg[normal]=red,bg[sel]=red" >
        </tree>
      </tree>
      <tree style="fg[sel]=pink,bg[sel]=black" label="hello">
      </tree>
    </tree>

    <notebook style="fg[norm]=red">
      <notepage style="fg[norm]=blue" title="one">
        <button label="one(1)"/>
      </notepage>
      <notepage style="fg[norm]=red" title="two">
        <button label="two(2)"/>
      </notepage>
    </notebook>

  </window>


  <window title="Clist Style Test" visible="false">
    <clist expand="true" style="base[normal]=yellow">
      <cl-row>
        <cl-header title="one"/>
      </cl-row>
      <cl-row>
        <string text="hello?"/>
      </cl-row>
      <cl-row>
        <string text="This is not going to be easy to make work..."/>
      </cl-row>
    </clist>
  </window>

  <!-- this one works as expected... no real need to test it. -->
  <window title="List Style Test" visible="false">
    <list expand="true" style="base[normal]=gray">
     <list-item label="one" style="fg[norm]=green"/>
    </list>
  </window>

  <!-- this one works as expected... no real need to test it. -->
  <window title="CList Style Test" visible="true">
    <clist expand="true" style="font[normal]=green">
     <cl-row><cl-header title="hello"/><cl-header title="hello2"/></cl-row>
     <cl-row style="fg[norm]=red,base[norm]=green">
       <string text="hello"/>
       <string text="hello"/>
     </cl-row>
     <cl-row style="fg[norm]=blue,fg[sel]=red,bg[sel]=pink">
       <string text="hello"/>
       <string text="2hello"/>
     </cl-row>
     <cl-row onselect="revert"
        style="base[norm]=green,fg[norm]=blue,bg[sel]=black,fg[sel]=yellow">
       <string text="2hello"/>
       <string text="hello"/>
     </cl-row>
    </clist>
  </window>

  <perl><![CDATA[
  sub revert { shift->attrib("style"=>""); }
  ]]></perl>

</object>
