/*
 *
 *   (C) Copyright IBM Corp. 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libmac.so
 *
 *   File: helpers.h
 */
#ifndef _MAC_HELPERS_HEADER
        #define _MAC_HELPERS_HEADER 1

        #include <endian.h>

DISKSEG *           allocate_mac_segment( LOGICALDISK *object );

void                free_mac_segment( DISKSEG *seg);

DISKSEG *           create_mac_metadata_segment( storage_object_t  *object,
                                                 lba_t              start,
                                                 sector_count_t     size,
                                                 u_int32_t          flags,
                                                 char              *name  );

DISKSEG *           create_mac_data_segment( LOGICALDISK        *ld,
                                             lba_t               start,
                                             sector_count_t      size, 
                                             mac_partition_t    *p,
                                             u_int32_t           minor,
                                             u_int32_t           pmap_index,
                                             u_int32_t           object_flags );

int                 remove_mac_segment_from_list( list_anchor_t  seglist, DISKSEG *seg );

int                 insert_mac_segment_into_list( list_anchor_t  seglist, DISKSEG *seg);

int                 insert_mac_segment_into_ordered_list( list_anchor_t  seglist, DISKSEG *seg);

void                prune_mac_seg_objects_from_list( list_anchor_t list );


        #if __BYTE_ORDER == __LITTLE_ENDIAN
static inline uint16_t  MAC_DISK_TO_CPU16( uint16_t x )
{ 
        return(bswap_16(x));
}
static inline uint32_t  MAC_DISK_TO_CPU32( uint32_t x )
{
        return(bswap_32(x));
}
static inline uint64_t  MAC_DISK_TO_CPU64( uint64_t x )
{
        return(bswap_64(x));
}
static inline uint16_t  CPU_TO_MAC_DISK16( uint16_t x )
{ 
        return(bswap_16(x));
}
static inline uint32_t  CPU_TO_MAC_DISK32( uint32_t x )
{
        return(bswap_32(x));
}
static inline uint64_t  CPU_TO_MAC_DISK64( uint64_t x )
{
        return(bswap_64(x));
}
        #else
static inline uint16_t  MAC_DISK_TO_CPU16( uint16_t x )
{ 
        return(x);
}
static inline uint32_t  MAC_DISK_TO_CPU32( uint32_t x )
{
        return(x);
}
static inline uint64_t  MAC_DISK_TO_CPU64( uint64_t x )
{
        return(x);
}
static inline uint16_t  CPU_TO_MAC_DISK16( uint16_t x )
{ 
        return(x);
}
static inline uint32_t  CPU_TO_MAC_DISK32( uint32_t x )
{
        return(x);
}
static inline uint64_t  CPU_TO_MAC_DISK64( uint64_t x )
{
        return(x);
}
        #endif


static inline LOGICALDISK * get_logical_disk( storage_object_t *object )
{
        LOGICALDISK  *ld=NULL;

        if (object) {

                if (object->object_type == DISK) {
                        ld = object;
                }
                else if (object->object_type == SEGMENT && object->plugin == mac_plugin) {

                        if (object->private_data) {

                                if ( ((seg_private_data_t *)object->private_data)->signature == MAC_SEGMENT_PDATA_SIGNATURE ) {

                                        ld = ((seg_private_data_t *)object->private_data)->logical_disk;

                                }

                        }

                }

        }

        return ld;
}


static inline boolean isa_mac_logical_disk( storage_object_t *ld )
{
        disk_private_data_t *pdata;

        if (ld) {

                pdata = get_mac_disk_private_data(ld);

                if (pdata) {
                        return TRUE;
                }

        }

        return FALSE;
}


static inline boolean isa_mac_segment( storage_object_t *object )
{
        seg_private_data_t *pdata;

        if (object) {

                pdata = (seg_private_data_t *) object->private_data;

                if (pdata) {

                        if ( (object->plugin == mac_plugin) &&                        
                             (pdata->signature == MAC_SEGMENT_PDATA_SIGNATURE)) {
                                return TRUE;
                        }

                }

        }

        return FALSE;
}


static inline void display_mac_disklabel( mac_disklabel_t *disk_label )
{
        if (disk_label) {
                LOG_DEBUG("MAC Disk Label Info:\n");
                LOG_DEBUG("     block size   = %d\n", MAC_DISK_TO_CPU16(disk_label->block_size));
                LOG_DEBUG("     block count  = %d\n", MAC_DISK_TO_CPU32(disk_label->block_count));
                LOG_DEBUG("     device type  = %d\n", MAC_DISK_TO_CPU16(disk_label->dev_type));
                LOG_DEBUG("     device id    = %d\n", MAC_DISK_TO_CPU16(disk_label->dev_id));
                LOG_DEBUG("     data         = %d\n", MAC_DISK_TO_CPU32(disk_label->data));
                LOG_DEBUG("     driver count = %d\n", MAC_DISK_TO_CPU16(disk_label->driver_count));
                LOG_DEBUG("     start useable = %d\n", MAC_DISK_TO_CPU32(disk_label->start));
                LOG_DEBUG("     size          = %d\n", MAC_DISK_TO_CPU32(disk_label->size));
                LOG_DEBUG("     os type       = %d\n", MAC_DISK_TO_CPU16(disk_label->os_type));
        }
        else {
                LOG_ERROR("display_mac_header: error, null ptr arg\n");
        }
}

static inline boolean disk_move_pending( storage_object_t *object )
{               
        LOGICALDISK        *ld=get_logical_disk(object);        
        disk_private_data_t *disk_pdata=NULL;

        if ( ld ) {

                disk_pdata = get_mac_disk_private_data(ld);

                if (disk_pdata) {

                        if (disk_pdata->flags & DISK_HAS_MOVE_PENDING) {
                                return TRUE;
                        }

                }

        }

        return FALSE;
}


#endif

