/***************************************************************************
                          FLReportViewer.cpp  -  description
                             -------------------
    begin                : vie jun 28 2002
    copyright            : (C) 2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "FLReportViewer.h"
#include "FLReportEngine.h"
#include "../kugar/mreportviewer.h"

FLReportViewer::FLReportViewer (QWidget * parent, const char *name):
FLWidgetReportViewer (parent, name, Qt::WDestructiveClose | Qt::WType_Dialog | Qt::WShowModal)
{
  rptEngine = new FLReportEngine ();
  rptViewer = new MReportViewer (this);

  rptViewer->setReportEngine (rptEngine);

  setFont (qApp->font ());
  setFocusPolicy (QWidget::StrongFocus);

  setCentralWidget (rptViewer);
}

FLReportViewer::~FLReportViewer ()
{
  if (rptViewer)
	delete rptViewer;
}

bool
FLReportViewer::renderReport ()
{
  return rptViewer->renderReport ();
}

void
FLReportViewer::slotFirstPage ()
{
  rptViewer->slotFirstPage ();
}

void
FLReportViewer::slotLastPage ()
{
  rptViewer->slotLastPage ();
}

void
FLReportViewer::slotNextPage ()
{
  rptViewer->slotNextPage ();
}

void
FLReportViewer::slotPrevPage ()
{
  rptViewer->slotPrevPage ();
}

void
FLReportViewer::slotExit ()
{
  close ();
}

void
FLReportViewer::slotPrintReport ()
{
  rptViewer->printReport ();
}

bool
FLReportViewer::setReportData (FLSqlQuery * q)
{
  return rptEngine->setReportData (q);
}

bool
FLReportViewer::setReportData (FLSqlCursor * t)
{
  return rptEngine->setReportData (t);
}

bool
FLReportViewer::setReportTemplate (const QString & t)
{
  return rptEngine->setFLReportTemplate (t);
}

QSize
FLReportViewer::sizeHint () const
{
  return rptViewer->sizeHint ();
}
