/*
 * Miscellaneous string-handling related utility-functions
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2002-2003 Tecnic Software productions (TNSP)
 *
 * Please read file 'COPYING' for information on license and distribution.
 */
#include "th_util.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>


int th_strcalloc(char **result, const char *str)
{
 /* Check the string pointers */
 if (!result || !str) return -1;

 /* Allocate memory for destination */
 *result = (char *) realloc(*result, strlen(str) + 1);
 if (*result == NULL) return -2;

 /* Copy to the destination */
 strcpy(*result, str);

 return 0;
}


int th_strcat(char **result, const char *str)
{
 int ilen;

 /* Check the string pointers */
 if (!result || !str) return -1;

 if (*result != NULL)
	ilen = strlen(*result);
	else
	ilen = 0;
	
 /* Allocate memory for destination */
 *result = (char *) realloc(*result, ilen + strlen(str) + 1);
 if (*result == NULL) return -2;

 /* Copy to the destination */
 strcat(*result, str);

 return 0;
}


int th_strcpy(char **result, const char *str)
{
 /* Check the string pointers */
 if (!result || !str) return -1;

 /* Allocate memory for destination */
 *result = (char *) malloc(strlen(str) + 1);
 if (*result == NULL) return NULL;

 /* Copy to the destination */
 strcpy(*result, str);

 return 0;
}


char *th_strdup(const char *str)
{
 char *result;
 
 /* Check the string pointers */
 if (!str) return NULL;

 /* Allocate memory for destination */
 result = (char *) malloc(strlen(str) + 1);
 if (result == NULL) return -2;

 /* Copy to the destination */
 strcpy(result, str);

 return result;
}


void th_findnext(char *str, int *ipos)
{
 /* Terminating NULL-character is not whitespace! */
 while (th_isspace(str[*ipos])) (*ipos)++;
}


void th_findsep(char *str, int *ipos, char chSep)
{
 /* Terminating NULL-character is not digit! */
 while (str[*ipos] && (str[*ipos] != chSep)) (*ipos)++;
}


void th_findseporspace(char *str, int *ipos, char chSep)
{
 /* Terminating NULL-character is not digit! */
 while ((!th_isspace(str[*ipos])) && (str[*ipos] != chSep)) (*ipos)++;
}


BOOL th_strmatch(char *pStr, char *pPattern)
{
 BOOL didMatch, isAnyMode, isEnd;
 char *tmpPattern = NULL;

 /* Check given pattern and string */
 if (pStr == NULL) return FALSE;
 if (pPattern == NULL) return FALSE;

 /* Initialize */
 didMatch = TRUE;
 isEnd = FALSE;
 isAnyMode = FALSE;
 
 /* Start comparision */
 do 
 {
 didMatch = FALSE;
 switch (*pPattern) {
 case '?':
	/* Any single character matches */
	if (*pStr)
		{
		didMatch = TRUE;
		pPattern++;
		pStr++;
		}
	break;

 case '*':
 	didMatch = TRUE;
 	pPattern++;
 	if (!*pPattern) isEnd = TRUE;
 	isAnyMode = TRUE;
 	tmpPattern = pPattern;
 	break;

 case 0:
	if (isAnyMode)
	{
	if (*pStr)
		pStr++;
		else
		isEnd = TRUE;
	} else {
	if (*pStr)
		{
		if (tmpPattern)
			{
			isAnyMode = TRUE;
			pPattern = tmpPattern;
			} else
			didMatch = FALSE;
		} else
		isEnd = TRUE;
	}
 	break;
 default:
	if (isAnyMode)
	{
	if ((*pPattern) == (*pStr))
		{
		isAnyMode = FALSE;
		didMatch = TRUE;
		} else {
		if (*pStr)
			{
			didMatch = TRUE;
			pStr++;
			}
		}
	} else {
	if ((*pPattern) == (*pStr))
		{
		didMatch = TRUE;
		if (*pPattern) pPattern++;
		if (*pStr) pStr++;
		} else {
		if (tmpPattern)
			{
			didMatch = TRUE;
			isAnyMode = TRUE;
			pPattern = tmpPattern;
			}
		}
	}

	if (!*pStr && !*pPattern) isEnd = TRUE;
	break;

 } /* switch */

 } while ((didMatch) && (!isEnd));

 return didMatch;
}


BOOL th_strcasematch(char *pStr, char *pPattern)
{
 BOOL didMatch, isAnyMode, isEnd;
 char *tmpPattern = NULL;

 /* Check given pattern and string */
 if (pStr == NULL) return FALSE;
 if (pPattern == NULL) return FALSE;

 /* Initialize */
 didMatch = TRUE;
 isEnd = FALSE;
 isAnyMode = FALSE;
 
 /* Start comparision */
 do 
 {
 switch (*pPattern) {
 case '?':
	/* Any single character matches */
	if (*pStr)
		{
		pPattern++;
		pStr++;
		} else
		didMatch = FALSE;
	break;

 case '*':
 	pPattern++;
 	if (!*pPattern || (*pPattern == '?')) isEnd = TRUE;
 	isAnyMode = TRUE;
 	tmpPattern = pPattern;
 	break;

 case 0:
	if (isAnyMode)
	{
	if (*pStr)
		pStr++;
		else
		isEnd = TRUE;
	} else {
	if (*pStr)
		{
		if (tmpPattern)
			{
			isAnyMode = TRUE;
			pPattern = tmpPattern;
			} else
			didMatch = FALSE;
		} else
		isEnd = TRUE;
	}
 	break;
 	
 default:
	if (isAnyMode)
	{
	if (th_tolower(*pPattern) == th_tolower(*pStr))
		{
		isAnyMode = FALSE;
		} else {
		if (*pStr)
			pStr++;
			else
			didMatch = FALSE;
		}
	} else {
	if (th_tolower(*pPattern) == th_tolower(*pStr))
		{
		if (*pPattern) pPattern++;
		if (*pStr) pStr++;
		} else {
		if (tmpPattern)
			{
			isAnyMode = TRUE;
			pPattern = tmpPattern;
			} else
			didMatch = FALSE;
		}
	}

	if (!*pStr && !*pPattern) isEnd = TRUE;
	break;

 } /* switch */
 
 } while ((didMatch) && (!isEnd));

 return didMatch;
}
