#include <assert.h>
#include <iostream>
#include <stdlib.h>

#include <string>
#include <fstream>

#include <Client.h>
#include <Utils.h>

using namespace std;
using namespace CORBA;

int
run(ORB_ptr orb, int argc, char* argv[])
{
    try {
	Object_var obj = get_ior_from_file(orb, "Server.ref");
	if (is_nil(obj.in())) {
	    cerr << argv[0]
		 << ": cannot read IOR from Server.ref"
		 << endl;
	    return EXIT_FAILURE;
	}
	
	TestChars_var p = TestChars::_narrow(obj.in());
	assert(!is_nil(p.in()));

	{
	    WChar wc, wcRet;

	    wc = L'a';
	    wcRet = p -> testWChar(wc);
	    cerr << wc << ' ' << wcRet << endl;
	    assert(wc == wcRet);
	}

	{
	    WString_var ws, wsRet;

	    ws = wstring_dup((CORBA::WChar*)L"hello");
	    wsRet = p -> testWString(ws.in());
            cerr << wsRet << endl;

	    write_wstring_data(cerr, ws.in());
	    write_wstring_data(cerr, wsRet.in());

	    assert(wstring_compare(ws.in(), wsRet.in()));
	}
    } catch (const Exception& ex) {
	write_ex(cerr, ex);
	return 1;
    }

    return 0;
}

int
main(int argc, char* argv[])
{
    int status = EXIT_SUCCESS;
    ORB_var orb;

    try {
        //
        // Create ORB
        //
        orb = ORB_init(argc, argv);

	//
	// Run the test
	//
	status = run(orb.in(), argc, argv);
    } catch (const Exception& ex) {
	write_ex(cerr, ex);
        status = EXIT_SUCCESS;
    }

    return status;
}

