#import "Globals.h"

#define kFreeCraftSite @"http://freecraft.sourceforge.net/"

@interface InstallerController : NSObject
{

	// The panel that displays installation progress
    IBOutlet id installationPanel;
    IBOutlet id installLocationLabel;
	
	// The progress bar in the installation panel and the label above it
    IBOutlet id progress;
    IBOutlet id progressLabel;
	
	// Displays to the user the expected download size
    IBOutlet id totalDownloadLabel;
	
	// The other installer objects
	IBOutlet id installerSDL, installerPrefs, installerMedia, installerMusic, installerFrameworks;
	
	// The label specifying which version of FreeCraft is being installed
	IBOutlet id freecraftLabel;
	
	// The window presented to the user with installation options
	IBOutlet id window;
	
	// The installerTools object
	id tools;
	
	// The installerDownload object
	id downloader;
	
	// Determines whether the user can exit
	BOOL canExit;
	
}

// Sets things up for the user
- (void)awakeFromNib;

// Prepares the instance for destruction
- (void)dealloc;

// Returns the installation path
- (NSString *)destinationPath;

// Called when a particular download fails
- (void)downloadFailed:(id)sender reason:(NSString *)reason;

// Called as downloading progresses
- (void)downloadProgress:(id)sender value:(double)value;

// Called to prepare for installation
- (BOOL)prepare;

// Launches the FreeCraft website
- (IBAction)launchWebsite:(id)sender;

// Allows the user to customize the installation path
- (IBAction)selectLocation:(id)sender;

// Starts the install
- (IBAction)start:(id)sender;

// If possible, stops the install
- (IBAction)stop:(id)sender;

// Called once donwloading has finished to finish the install
- (void)downloadsFinished:(id)sender;

// Called when a particular tool fails
- (void)toolFailed:(id)sender named:(NSString *)name code:(int)code;

// Returns the installerTools object
- (id)tools;

// Update the total amount to be downloaded
- (void)updateTotalDownload;

@end
