#import "InstallerTools.h"

@implementation InstallerTools

- (id)initWithClient:(id)newClient
{
	// Call the super
	if ([super init] == NULL)
		return NULL;
	
	// Set client appropriately
	client = newClient;
	
	return self;
}

- (BOOL)gunzip:(NSString *)file
{
	NSArray *arguments;
	
	// Set up arguments
	arguments = [NSArray arrayWithObjects:file, nil];
	
	// Run task
	task = [NSTask launchedTaskWithLaunchPath:[toolsPath stringByAppendingString:@"gunzip"] arguments:arguments];
	[task waitUntilExit];
	
	// Inform client of failure if he wants to know
	if ([task terminationStatus] != 0 && [client respondsToSelector:@selector(toolFailed: named:)] == YES) {
		[client toolFailed:self named:@"gunzip" code:[task terminationStatus]];
	}
	
	return ([task terminationStatus] == 0);
}

- (BOOL)gzip:(NSString *)file
{
	NSArray *arguments;
	
	// Set up arguments
	arguments = [NSArray arrayWithObjects:file, nil];
	
	// Run task
	task = [NSTask launchedTaskWithLaunchPath:[toolsPath stringByAppendingString:@"gzip"] arguments:arguments];
	[task waitUntilExit];

	// Inform client of failure if he wants to know
	if ([task terminationStatus] != 0 && [client respondsToSelector:@selector(toolFailed: named:)] == YES) {
		[client toolFailed:self named:@"gzip" code:[task terminationStatus]];
	}
	
	return ([task terminationStatus] == 0);
}

- (BOOL)tar:(NSString *)file destination:(NSString *)directory
{
	NSArray *arguments;
	
	// Set up arguments
	arguments = [NSArray arrayWithObjects:@"-x", @"-f", file, @"-C", directory, nil];
	
	// Run task
	task = [NSTask launchedTaskWithLaunchPath:[toolsPath stringByAppendingString:@"gnutar"] arguments:arguments];
	[task waitUntilExit];
	
	// Inform client of failure if he wants to know
	if ([task terminationStatus] != 0 && [client respondsToSelector:@selector(toolFailed: named:)] == YES) {
		[client toolFailed:self named:@"tar" code:[task terminationStatus]];
	}
	
	return ([task terminationStatus] == 0);
}

@end
