
/* $Id: avl_tree.h,v 1.1 2002/01/15 21:17:52 latimerius Exp $ */

#ifndef AVL_TREE_H
#define AVL_TREE_H

typedef struct avl_tree_node {
	void *data;
	char balance;
	int key;
	struct avl_tree_node *subtree[2];
#ifdef PRINT_TREE
	char seqno;
	char entrylen;
#endif
} AvlTreeNode;

typedef AvlTreeNode AvlTree;

extern void AvlFlush (AvlTree * );
extern void AvlAdd (AvlTree * , void * , int );
extern void *AvlDelete (AvlTree * , int );
extern void *AvlFind (AvlTree * , int );
#ifdef PRINT_TREE
extern void AvlPrint (AvlTree * );
#endif /* PRINT_TREE */

#endif /* AVL_TREE_H */
