//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: EliminatedFictitiousDomain.cpp,v 1.3 2003/12/26 18:38:02 uid68082 Exp $

#include <EliminatedFictitiousDomain.hpp>
#include <BoundaryConditionDiscretizationElimination.hpp>

template <typename MeshType>
ReferenceCounting<BoundaryConditionDiscretization>
EliminatedFictitiousDomain::__discretizeBoundaryConditions()
{
  BoundaryConditionDiscretizationElimination<MeshType>* bcDiscretization
    = new BoundaryConditionDiscretizationElimination<MeshType>(problem(),
							       dynamic_cast<MeshType&>(mesh()),
							       (*__degreeOfFreedomSet));
  (*bcDiscretization).associatesMeshesToBoundaryConditions();
  return bcDiscretization;
}

ReferenceCounting<BoundaryConditionDiscretization>
EliminatedFictitiousDomain::discretizeBoundaryConditions()
{
  switch (mesh().type()) {
  case Mesh::cartesianHexahedraMesh: {
    return this->__discretizeBoundaryConditions<Structured3DMesh>();
    break;
  }
  default: {
    fferr(0) << __FILE__ << ':' << __LINE__ << ": Not implemented\n";
    fferr(0) << "this mesh type is not supported by FDM penalty\n";
    std::exit(1);
    return 0;
  }
  }
}
