proc fvInit { args } {
   global isExitting plugin
   global env

   #  Prevent doing this twice
   if { ![info exists isExitting] } {
      
      # Load Itcl/Itk packages

       package require Itcl
       package require Itk

   # Strange behaviour of mktclapp. For standalone, this statement
   # causes trouble
       if ![info exists env(FV_ISEXEC) ] { 
           package require Iwidgets 
       }
       
      eval fvApp fv $args
   } elseif { [find object fv]!="" } {
      fv processOptions $args
   }
   after idle checkForExit
   return
}


proc selFile {{dir {}} } {
   if { $dir != {} } {
      .fD chgDir $dir
   }
   .fD activate Open
}


proc getSelectedFileName { defName } {
   global fileselect

   .fD activate Save $defName

   # wait till a file is selected  
   tkwait variable fileselect

   return $fileselect
}


proc createNewFITS { {file ""} } {
    if { [itcl::find objects .newfits] != ""} {
	delete object .newfits
    }

# NEWFITS cleans itself afterwards. No need to delete
    NewFITS .newfits $file -title "fv: Create Image"
    
    tkwait window .newfits 
}

proc openFile { filename } {
    global isWin isScript openDir
    
    if $isWin {
        set filename [file attributes $filename -longname]
    }
    if { [file extension $filename] == ".fv" } {
        set isScript 1
        namespace eval ::fvCmds [list source $filename]
        set isScript 0
    } else { 
        if { [file isdirectory $filename] } {
            set openDir $filename
        } else {
            if { [catch {openFitsFile $filename} msg] } {
                tk_messageBox -type ok -icon warning \
                        -message "Cannot open file $filename\n\n$msg"
            }
        }
    } 
}


proc openFitsFile {filename} {
    global fitsFileMode

    set ffmode $fitsFileMode
    return [openFitsFileWM $filename $ffmode]
}

proc openFitsFileWM {filename ffmode} {

   if { [string range $filename 0 5]!= "ftp://" && \
	 [string range $filename 0 6]!= "http://" } {

      # This is a local file so resolve any symlinks
      # and see if the file exists

      set filename [resolveSymLinks $filename]
      if { ![file exists $filename] } {
         set resp [tk_messageBox -icon error -type yesno \
               -message "$filename doesn't exists.\nCreate new file?" \
               -title "File doesn't exist"]
         if { $resp=="no" } {
            return ""
         }
         createNewFITS $filename
         return ""
      }
   }

    set isfits [isFits $filename]
    if { $isfits == 0 } {
	error "$filename is not a FITS file"
	return ERROR
    } 

#the fitsfilemode is fed from the file dialog. 1=readonly, 0=read/write

    if { $ffmode == 0 } {
        if { ![file writable $filename] } {
	    puts "File is not writable, open as read only"
	    set ffmode 1
	} elseif {$isfits == 2} {
	    puts "File is compressed, open as read only"
	    set ffmode 1
	}
    }
    set fF [FitsFile #auto $filename $ffmode]
    
    return $fF
}

set ::fvHelpFiles [list \
      "About fv"               aboutFv.html          \
      "Calculator"             calculator.html       \
      "Column Selection"       columnSelection.html  \
      "Column Statistics"      columnStatistics.html \
      "Create New FITS File"   createNewFITS.html    \
      "Deleting Rows"          deleteRows.html       \
      "Desktop Manager"        deskTopManager.html   \
      "Display Format"         displayFormat.html    \
      "Calculator Expressions" expressions.html      \
      "File Summary"           fileSummary.html      \
      "File Selection"         fileSelection.html    \
      "Header Display"         headerDisplay.html    \
      "Image Plots"            imagePlot.html        \
      "Plot Dialog"            plotDialog.html       \
      "Preferences"            preferences.html      \
      "Sorting Columns"        sortColumn.html       \
      "Scripting"              scripting.html        \
      "SkyView"                SkyView.html          \
      "Catalog Database"       catalog.html          \
      "FTOOL Execution"        ftool.html            \
      "Table Display"          tableDisplay.html     \
      "Image Tables"           imageDisplay.html     \
      "Histograms"             2D-Histogram.html     \
      "3D Image Tables"        3D-ImageTable.html    \
      "3D Image Display"       3D-ImageDisplay.html  \
      ]

proc hhelp {topic} {
  global FITSVIEWER_LIBRARY fvHelpFiles
  global isWin
  global env

  if { [string match "*.html" $topic] } {
     set topic [string range $topic 0 end-5]
  }
   
  if { [winfo exist .hyperHelp] == 0} {
      if { $isWin } {
         set size large
      } else {
         set size medium
      }
      set allTopics {}
      foreach [list aTitle aTopic] $fvHelpFiles {
         lappend allTopics [list $aTitle $aTopic]
      }
      iwidgets::hyperhelp .hyperHelp -title "fv: Hyperhelp" \
            -topics $allTopics \
            -fontname courier -fontsize $size \
            -helpdir	 $env(FV_HELPDIR)
#	  -helpdir	 [file join "$FITSVIEWER_LIBRARY" doc]
  } 
    .hyperHelp showtopic $topic
    catch {.hyperHelp activate}
} 

proc promptMsg {text command okText cancelText} {
global isWin

#   For some reasons, we can not activate the messagedialog on windows,
#   We have use tk_messagebox instead. 

    if {$isWin } { 
        if {$cancelText == "Cancel" } {
          set choice [tk_messageBox -type yesnocancel -default yes \
             -message $text -icon question ]
        } else {
          set choice [tk_messageBox -type yesno -default yes \
             -message $text -icon question ]
        }
        if { $choice == "yes"  } {
          $command
	  return
        } elseif {$choice == "cancel"} {
	    return BREAK
        } else {
	    return CANCEL
        }
       
    }    

    # Make sure all windows get mapped first, then popup window
    update idletasks
    if { [winfo exist .md] == 0} {
# load  the message dialog if not exist
       iwidgets::messagedialog .md -title "fv: Message Dialog" \
 	    -bitmap questhead \
	    -modality application
    } 
    .md configure -text $text 
    .md buttonconfigure OK -text $okText 
    .md buttonconfigure Cancel -text No      
    if { $cancelText == "Cancel" } {
	.md show Help
	.md buttonconfigure Help -text Cancel -command ".md deactivate 2"
    } else {
        .md hide Help
    }
    set fb [.md activate]

    if { $fb == 1  } {
	$command
	return
    } elseif {$fb == 0} {
	return CANCEL
    } else {
	return BREAK
    }
    
}



proc cleanBackupDir {} {
    global backupDir

    if { [catch {set filelist [glob [file join $backupDir *]]}] == 1 } return

    foreach i $filelist {
	file delete $i
    }
}


proc checkForExit { } {
   global listObjs isMac isExitting isQuiet

   # If there is still a file or Manager open, or on Mac, continue
   if {     $isExitting \
         || $isMac || $isQuiet \
         || [llength $listObjs]>0 \
         || $fvPref::ifUseManager \
         || ([winfo exists .fD] && [winfo ismapped .fD]) } {
      return
   }
   exitCmd
}


proc exitCmd { {force 0} } {
    global listObjs isExitting isQuiet
    if { $isExitting } return

    # Once we have reached this point, cease being a quiet application
    set isQuiet 0
    foreach i $listObjs {
       if { [$i closeCmd $force] } return
    }
    set isExitting 1 
    after idle {delete object fv}
}


# convert a decimal degree to HH MM SS.S
proc hourRA {deciValue} {
    set hourValue [expr $deciValue/15.0]
    set hour [expr int($hourValue)]
    set minuValue [expr ($hourValue - $hour)*60.0]
    set minu [expr int($minuValue)]
    set scndValue [expr ($minuValue - $minu)*60.0]
    set scnd $scndValue
    return [format "%d:%02d:%05.2f" $hour $minu $scnd]

}

# convert a decimal degree to DD MM SS.S
proc degDec {deciValue} {
    if { $deciValue < 0} {
	set isNeg 1
    } else {
	set isNeg 0
    }
    set deciValue [expr abs($deciValue)]
    set deg [expr int($deciValue)]
    set minuValue [expr ($deciValue - $deg)*60.0]
    set minu [expr int($minuValue)]
    set scndValue [expr ($minuValue - $minu)*60.0]
    set scnd $scndValue
    if { $isNeg == 1} {
	return [format "-%d:%02d:%05.2f" $deg $minu $scnd]
    } else {
	return [format "%d:%02d:%05.2f" $deg $minu $scnd]
    }
}

proc validColName {text} {
    return [regexp -nocase {[0-9a-z_A-Z ]} $text]
}


proc returnCurrentImageInfo {father extno img x y} {

    set gn [powWhereAmI [.pow.pow canvasx $x] [.pow.pow canvasy $y]]
    if { $gn == "NULL" } return

    set cx [.pow.pow canvasx $x]
    set cy [.pow.pow canvasy $y]
    set ccord  [powCanvasToPixel $gn $img $cx $cy]
    set pixelx [expr round([lindex $ccord 0]) + 1]
    set pixely [expr round([lindex $ccord 1]) + 1]

    $father openTable $extno [list $pixelx $pixely]
}


proc getFullDirPath { file } {
   global isWin isMac

   if { [string range $file 0 5] == "ftp://" || \
	 [string range $file 0 6] == "http://" } {

      set dName [string range $file 0 [string last "/" $file]]

   } else {

       if { $isMac } {
	  set dirChar ":"
      } else {
	  set dirChar "/"
      }
      
      set dName [file dirname $file]
      if { [string range $dName end end]!=$dirChar } {
         set dName $dName$dirChar
      }
      
      if {     (!$isWin && !$isMac && [string range $dName 0 0] != "/") \
	    || ($isWin && [string range $dName 1 2]!=":/" \
	        && [string range $dName 0 0]!="/") \
	    || ($isMac && [string range $dName 0 0]==":") } {
	 if { $dName == ".$dirChar"} {
	    set dName [pwd]$dirChar
	 } elseif { $isMac } {
	    set dName [file join [pwd] $dName]$dirChar
	 } else {
	    set dName [pwd]$dirChar$dName
	 }
      }

   }
   return $dName
}

proc setWatchCursor { win args } {
#   puts "$win $args"
   .fvwinkeeper setCursor watch
   if { $win != "" } {
      $win configure -cursor watch
   }
   update

   catch {set rslt [eval $args]} err

   if { $win != "" } {
      $win configure -cursor top_left_arrow
   }
   .fvwinkeeper setCursor top_left_arrow

   if { [info exists rslt] } {
      return $rslt
   } else {
      error $err
   }
}


proc doMenuEvent { evt {evtWndw ""} } {
   global lastEventWndw isMac isWin

# This evtWndw messiness is necessary due to LinuxPPC's (and others?) problems
# in tracking the focus when selecting menu items.  Can't tell if it is a
# Window Manager problem or Tk problem.


   if { $evt == "<<PostMenus>>" } {
       set whn "now"
       set lastEventWndw $evtWndw
   } else {
       set whn "tail"
   }
   if { $evtWndw=="" } {
      if { $lastEventWndw=="" } {
         set evtWndw [focus]
      } else {
         set evtWndw $lastEventWndw
      }
   }

#   puts "Evt: $evt in $evtWndw"
   if { $evtWndw != "" && [winfo exists $evtWndw] } {
      if { $isMac && $evt=="<<Quit>>" } {
          exitCmd
      }
      if { $isWin && $evt=="<<Quit>>" } {
          exitCmd
      }
      event generate $evtWndw $evt -when $whn
   } else {
      event generate . $evt -when $whn
   }
}

# rename menu _menu
# proc menu { args } {
#     global myMenuCount
#     if { ![info exists myMenuCount] } { set myMenuCount 0}
#     incr myMenuCount
#     puts "menu [lindex $args 0]   ... $myMenuCount"
#     eval _menu $args
# }

proc BuildMacMenus { } {

   menu          .mbar       -postcommand "doMenuEvent <<PostMenus>>"
   bind all <<PostMenus>> postMacMenus
   buildApplMenu .mbar.apple
   buildFileMenu .mbar.file
   buildEditMenu .mbar.edit
   buildToolsMenu .mbar.tools
   buildWindMenu .mbar.wind
   buildHelpMenu .mbar.help aboutFv "About fv"
   .mbar.help delete 0 1

   . configure -menu .mbar
   .mbar add cascade -menu .mbar.apple
   .mbar add cascade -menu .mbar.file -label "File"
   .mbar add cascade -menu .mbar.edit -label "Edit"
   .mbar add cascade -menu .mbar.tools -label "Tools"
   .mbar add cascade -menu .mbar.wind -label "Windows"
   .mbar add cascade -menu .mbar.help -label "Help"
}


proc postMacMenus { } {
    #.fvwinkeeper updateMacWindows
}


proc buildApplMenu { theMenu } {
    menu $theMenu -tearoff False
    $theMenu add command -label "About fv" -command "hhelp aboutFv"
}


proc buildFileMenu { theMenu } {
   global isMac

   if { $isMac } {
      set cmdkey "Cmd"
   } else {
      set cmdkey "Alt"
   }
    
   menu $theMenu -tearoff False

   $theMenu add command -label "New File..." -underline 0 \
         -command createNewFITS -accelerator "$cmdkey+N"
   $theMenu add command -label "Open File..." -underline 0 \
         -command selFile -accelerator "$cmdkey+O"

   $theMenu add command -label "Save" -underline 0 -state disabled \
         -command "doMenuEvent <<SaveFile>>" -accelerator "$cmdkey+S"
   $theMenu add command -label "Save As..." -state disabled \
         -command "doMenuEvent <<SaveFileAs>>"
   $theMenu add command -label "Export" -underline 5 -state disabled \
         -command "doMenuEvent <<Export>>" -accelerator "$cmdkey+H"
   $theMenu add command -label "Revert" -underline 0 -state disabled \
         -command "doMenuEvent <<RevertFile>>" -accelerator "$cmdkey+R"
   $theMenu add command -label "Close"  -state disabled \
         -command "doMenuEvent <<CloseWindow>>" -accelerator "$cmdkey+W"
   
   $theMenu add command -label Quit -underline 0 \
         -command "doMenuEvent <<Quit>> ." -accelerator "$cmdkey+Q"

}


proc buildEditMenu { theMenu } {
   global isMac

   if { $isMac } {
      set cmdkey "Cmd"
   } else {
      set cmdkey "Alt"
   }
    
   menu $theMenu -tearoff False

   $theMenu add command -label Undo -state disabled \
         -command "doMenuEvent <<Undo>>"  -accelerator "$cmdkey+Z"
   $theMenu add separator
   $theMenu add command -label Cut -state disabled \
         -command "doMenuEvent <<Cut>>"   -accelerator "$cmdkey+X"
   $theMenu add command -label Copy -underline 0 -state disabled \
         -command "doMenuEvent <<Copy>>"  -accelerator "$cmdkey+C"
   $theMenu add command -label Paste -state disabled \
         -command "doMenuEvent <<Paste>>" -accelerator "$cmdkey+V"
   $theMenu add command -label Clear -state disabled \
         -command "doMenuEvent <<Clear>>"
   $theMenu add separator
   $theMenu add command -label Clipboard \
         -command "fvClipBoard toggleView"
   $theMenu add separator
   $theMenu add command -label "Preferences..." \
         -command "fvPref edit"
}

proc buildToolsMenu { theMenu } {
   global isMac
   global env

   if { $isMac } {
      set cmdkey "Cmd"
   } else {
      set cmdkey "Alt"
   }

   menu $theMenu -tearoff False
   $theMenu add command -label "Plot" -state disabled \
         -command "doMenuEvent <<PlotHDUs>>" 
   $theMenu add command -label Smooth -state disabled \
         -command "doMenuEvent <<Smooth>>" 
   $theMenu add command -label "Connect to SkyView" -state normal \
         -command {
                global skyvflag
                if ![info exists skyvflag ] {
                      set skyvflag 1
                      FVSkyview skyv
                }
                skyv getskyvfile
          }
   $theMenu add command -label "Connect to Catalog" -state normal \
         -command {
                global skyvflag
                if ![info exists skyvflag ] {
                      set skyvflag 1
                      FVSkyview skyv
                }
                skyv getskyvcat
          }

   if { [info exists env(FTOOLS)] || [info exists env(LHEASOFT)] } {
      $theMenu add command -label "Run Ftool" -state normal \
         -command {
                global ftoolflag
                if ![info exists ftoolflag ] {
                      set ftoolflag 1
                      FtoolInstance fvFtool
                }
                fvFtool MainMenu
         }
   }

}

proc buildWindMenu { theMenu } {

   menu $theMenu -tearoff False

   $theMenu add command -label "Hide All Windows" \
         -command ".fvwinkeeper actOn all"

   menu $theMenu.sm  -tearoff false
   menu $theMenu.hm  -tearoff false
   menu $theMenu.tm  -tearoff false
   menu $theMenu.itm -tearoff false
   menu $theMenu.vtm -tearoff false

   $theMenu add cascade -menu $theMenu.sm  -label "File Summary"
   $theMenu add cascade -menu $theMenu.hm  -label "Header"
   $theMenu add cascade -menu $theMenu.tm  -label "Table"
   $theMenu add cascade -menu $theMenu.itm -label "Image Table"
   $theMenu add cascade -menu $theMenu.vtm -label "Vector Table"

}


proc buildHelpMenu { theMenu firstTopic firstTitle } {
    menu $theMenu -tearoff False
    $theMenu add command -label $firstTitle -command "hhelp $firstTopic"
    $theMenu add separator
    foreach {title topic} $::fvHelpFiles {
        $theMenu add command -label $title -command "hhelp $topic"
    }
}


proc urlSplit { url } {
    global isMac

    set uPos [string first :// $url]
    if { $uPos == -1 } {
        return [file split $url]
    } else {
       set lst [string range $url 0 [expr $uPos+2]]
       eval lappend lst [split [string range $url [expr $uPos+3] end] /]
       if { [lindex $lst end]=="" } {
          set lst [lrange $lst 0 [expr [llength $lst]-2]]
       }
       return $lst
    }
}

proc urlTail { url } {
    return [lindex [urlSplit $url] end]
}


proc calcSizeStr { size } {
   if { [catch {expr $size+1}] } {
      return "???"
   }
   set unit 0
   set units [list "" k M G T ? ? ? ? ? ?]
   while { $size > 5632 } {
      incr unit
      set size [expr round( $size/1024.0 )]
   }
   return $size[lindex $units $unit]
}


proc calcDateStr { time } {
   if { $time=="-" || [catch {expr $time+1}] } {
      return "-"
   }
   if { $time > [clock scan "00:00 today"] } {
      set str [clock format $time -format "Today %H:%M"]
   } elseif { $time > [clock scan "00:00 6 days ago"] } {
      set str [clock format $time -format "%a  %H:%M"]
   } else {
      set str [clock format $time -format "%b %d, %Y"]
   }
   return $str
}


proc resolveSymLinks { filename } {

   if { [file type $filename] == "link" } {
      set lName [file readlink $filename]
      if { [file pathtype $lName] == "relative" } {
         set root [file dirname $filename]
         set lName [file join $root $lName]
      }
      return [resolveSymLinks $lName]
   }
   return $filename
}


proc loadTclCode { hostPath sourceFile } {
   package require http
   set urlToken [http::geturl "$hostPath/$sourceFile"]
   set contents [http::data $urlToken]
   http::cleanup $urlToken
   if { $sourceFile=="tclIndex" } {
      #  Munge standard tclIndex format into WWW format
      regsub -all {source \[file join \$dir} \
            $contents "loadTclCode $hostPath" tmp
      regsub -all {\]\]} $tmp {]} contents
   }
   namespace eval :: $contents
}
