
/* Preference window generator example */

#include <gai/gai.h>
#include <stdio.h>
#include "config.h"


static int check_default = 1, check_result, radio_default = 2, radio_result;
static int spin_default = 10, spin_result;
static int option_default = 1, option_result;
static int combo_default = 1, combo_result;
static GList *combo_list = NULL;

static char *default_name = "Jonas", *file_default = "Hello_fem_bananer", *result_name=NULL, *pass_default="Hello";
static char *pass_result=NULL, *file_result=NULL;
static char *radio_names[] = {"Apples", "Bananas", "Pears", "Strawberry", NULL};
static char *option_list[] = {"Cake", "Milk","Icecream", "Nuts", NULL};

static GaiSS spin_limits = {0, 40, 3};
static float spinfloat_default = 43.3, spinfloat_result;
static GaiSSF spinfloat_limits = {40.0, 60.0, 1.0, 1};
static GaiColor color_default = {0xf0, 0xd0, 0xc0, 0xa0}, color_result;

void func(void);

static GaiPI g_pref[] = {{GAI_NOTEBOOK, "Book one"},
		  {GAI_FRAME, "Folder 1"},
		       {GAI_TEXT, "Hello"},
 		       {GAI_TEXT|GAI_LEFT, "Duduesssssssssssssss"},
		       {GAI_TEXT|GAI_RIGHT, "Banana"},
		  {GAI_FRAME_E},
		  
		  {GAI_FRAME, "Folder 2"},
		       {GAI_TEXT, "Kalle anka"},
		       {GAI_TEXT, "Apple"},
		       {GAI_COMBO, "Network interface:", &combo_default, &combo_result, &combo_list},
		  {GAI_FRAME_E},
		  {GAI_HLINE},
		  {GAI_FRAME, "Folder 3"},
		       {GAI_ALL_RIGHT},
		       {GAI_TEXT, "Kalle anka2"},
		       {GAI_FRAME, "Folder Inside"},
		            {GAI_TEXT, "Kaniner"},
		            {GAI_TEXT, "Bavrar"},
		       {GAI_FRAME_E},
		       {GAI_TEXT, "Apple2"},
		  {GAI_FRAME_E},

		  {GAI_FRAME_R, "Right frame"},
		       {GAI_TEXT, "Hej!"},
		  {GAI_FRAME_E},

		  {GAI_NOTEBOOK_E},
		  
		  {GAI_NOTEBOOK, "Book two"},
		       {GAI_ALL_LEFT},
		       {GAI_TEXT|GAI_LEFT, "Hellooo"},
		       {GAI_CHECKBUTTON|GAI_CENTER, "My checkbutton", &check_default, &check_result},
		       {GAI_TEXT|GAI_RIGHT, "Hellooo2"},
		       {GAI_TEXT|GAI_CENTER, "<span foreground=\"blue\" size=\"x-large\">Blue Hello</span> is <i>cool</i>!"},
		       {GAI_COLORSELECTOR, "Background colour:", &color_default, &color_result},
		       {GAI_FILESELECTOR, "Image file:", &file_default, &file_result},
		       {GAI_BUTTON_IMAGE, "Hej!","gai-pref-icon.png", (void *)func},
		       {GAI_BUTTON_TEXT|GAI_RIGHT, "<i>Italic button</i>", (void *)func},
		       {GAI_BUTTON_STOCK, "<b>Bold stock button</b>", "gtk-open", (void *)func},
		  {GAI_NOTEBOOK_E},
		  
		  {GAI_NOTEBOOK, "Book three"},
		       {GAI_TEXTENTRY, "Enter your name:", &default_name, &result_name},
		       {GAI_RADIOBUTTON, radio_names, &radio_default, &radio_result},
		       {GAI_SPINBUTTON, "Some value", &spin_default, &spin_result, &spin_limits},
		       {GAI_SPINBUTTONFLOAT, "Float values", &spinfloat_default, &spinfloat_result, &spinfloat_limits},
		       {GAI_OPTIONMENU, "Options:",&option_default, &option_result, option_list},
		       {GAI_PASSWORDENTRY, "Secret", &pass_default, &pass_result},
		  {GAI_NOTEBOOK_E},
		  
		  {GAI_END}};
void func(void)
{
    printf("ksajldk\n");
}

void pref_func(void)
{
    int i;
    printf("Text entry returns:%s\nCheck button returns: %d\n", (char *)result_name, check_result);

    printf("Combo box (%d)\n",combo_result);
    for(i=0;i<g_list_length(combo_list);i++)
	printf("Entry %d is: %s\n",i,(char *)g_list_nth_data(combo_list,i));

    printf("colour is: %d %d %d\n",color_result.r, color_result.g, color_result.b);

    printf("Radio button choise is: %d\n",radio_result);
    printf("File selector result is: %s\n", file_result);
    printf("Option menu result is: %d\n", option_result);
    printf("Password entry is: %s\n",pass_result);
    printf("Spin button float: %f\n", spinfloat_result);
    printf("Spin button: %d\n", spin_result);

}


int main(int argc, char  **argv)
{
    printf("func:%x\n", (int)((void *)func));
    printf("files: %x(%s)\n",(int) &file_default, (char *)(&file_default)[0]);
    gai_init2(&applet_defines, &argc, &argv);

    combo_list = g_list_append(combo_list, "Hej");
    combo_list = g_list_append(combo_list, "asfsd");
    combo_list = g_list_append(combo_list, "asfsd2");
    
    gai_preferences2("Hello, this is a preference window", g_pref, "Example code for the prefrence window generator\n"
		     "Try it from the commandprompt to see how it works.\n",
		     (GaiCallback0 *)pref_func, NULL);

    gai_start();

    return 0;


}
