from ConfigWidget import ConfigWidget

import gtk
import gnome.ui

class ConfigColor(ConfigWidget):

    def __init__(self, attrs, getter, setter):

        ConfigWidget.__init__(self, attrs, getter, setter)
        label = attrs.get("label", "")

        lbl = gtk.Label(label)
        lbl.show()
        align = gtk.Alignment(0.0, 0.0, 0.0, 0.0)
        align.show()
        align.add(lbl)

        btn = gnome.ui.ColorPicker()
        btn.show()
        btn.connect("color-set", self.__on_change)

        colorname = self._get_config()
        color = gtk.gdk.color_parse(colorname)
        btn.set_i16(color.red, color.green, color.blue, 0xffff)

        self.__widgets = (align, btn)


    def get_widgets(self): return self.__widgets


    def __on_change(self, src, r, g, b, a):

        value = "#%02X%02X%02X" % (r/256, g/256, b/256)
        self._set_config("\"" + value + "\"")
