from Vault import Vault
from display.DataTarget import DataTarget

#
# Wrapper for data targets.
#
class TargetWrapper(object):

    def __init__(self, target):

        self.__dict__["_TargetWrapper__target"] = Vault(target)


    def __setattr__(self, name, value):

        try:
            self.__target(open).set_prop(name, value)
        except:
            import traceback; traceback.print_exc()


    def __getattr__(self, name):

        if name in DataTarget.AUTHORIZED_METHODS:
            return getattr(self.__control(open), name)

        try:
            return self.__target(open).get_prop(name)
        except:
            import traceback; traceback.print_exc()
            return Null
