#ifndef __PARSER_H__
#define __PARSER_H__

#include "tokeniser.h"

#include <glib.h>

struct _parse_node {
  token_node token;	/* not sure if token is the right name */
  struct _parse_node *left;
  struct _parse_node *right;
};

typedef struct _parse_node parse_tree;

parse_tree *make_parse_tree(token_list *list);
gchar *check_tree(parse_tree *tree);
void free_tree(parse_tree *tree);
double eval_tree(parse_tree *tree, double x);

#endif
