static char rcsid[] = "$Id: file_info.c,v 1.2 2003/05/30 22:25:25 gen-dbeeman Exp $";

/*
** $Log: file_info.c,v $
** Revision 1.2  2003/05/30 22:25:25  gen-dbeeman
** New version of kinetics library from Upi Bhalla, April 2003
**
*
*/

/* #include <sys/types.h> */
#include <fcntl.h>
#include <stdio.h>
#include <dirent.h>
#include "sim_ext.h"

/* This file is for obtaining file information for GENESIS
** e.g., for directory listings and to check on status of a given file.
*/

int do_file_exists(int argc, char** argv) {
	int n;

	initopt(argc, argv, "filename");
	if (G_getopt(argc, argv) < 0) {
		printoptusage(argc,argv);
		return 0;
	}
	n = open(optargv[1], O_RDONLY);
	if (n < 0)
		return 0;
	close(n);
	return 1;
}

char** do_dir_list(int argc, char** argv) {
	int i;
	int n;
	struct dirent** namelist;
	char **ret;

#ifdef Solaris
	ret = "Error";
	printf("Warning: do_dir_list not supported on Solaris\n");
#else
	initopt(argc, argv, "directory_path");
	if (G_getopt(argc, argv) < 0) {
		printoptusage(argc,argv);
		return (char**)(NULLArgv());
	}
	n = scandir(optargv[1], &namelist, 0, alphasort);
	if (n <= 0)
		return (char**)NULLArgv();
	ret = (char **)malloc((1 + n) * sizeof(char *));
	for (i = 0; i < n; i++) {
		ret[i] = (char *)malloc((1 + strlen(namelist[i]->d_name)) * sizeof(char));
		strcpy(ret[i], namelist[i]->d_name);
	}
	ret[n] = (char *)NULL;
#endif
	return ret;
}

int do_max_file_version(int argc, char** argv) {
	int i;
	int n;
	struct dirent** namelist;
	int len;
	char *f;
	int version = 0;

#ifdef Solaris
	ret = "Error";
	printf("Warning: do_max_file_version not supported on Solaris\n");
#else
	initopt(argc, argv, "directory_path file_basename");
	if (G_getopt(argc, argv) < 0) {
		printoptusage(argc,argv);
		return 0;
	}
	n = scandir(optargv[1], &namelist, 0, alphasort);
	f = optargv[2];
	len = strlen(f);

	for (i = 0; i < n; i++) {
		if (strncmp(f, namelist[i]->d_name, len) == 0) {
			int j = atoi(namelist[i]->d_name + len);
			if (version < j)
				version = j;
		}
	}
#endif
	return version;
}
