/*  GFC-Core: GTK+ Foundation Classes (Core Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  connection.hh - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GFC_G_CONNECTION_HH
#define GFC_G_CONNECTION_HH

#ifndef __GLIB_GOBJECT_H__
#include <glib-object.h>
#endif

namespace GFC {

namespace G {

// Connection manages the connection between a sigc::slot and a G::Signal.

struct Connection : public sigc::connection
{
	GObject *object_;
	unsigned long connect_id_;
	sigc::slot_base slot_;

	Connection(GObject *object, const sigc::slot_base& slot);
	~Connection();

	static void* notify_handler(void *data);
	static void destroy_handler(void *data);
};

} // namespace G

} // namespace GFC

#endif // GFC_G_CONNECTION_HH

