/*  GFC-Core: GTK+ Foundation Classes (Core Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  marshal.hh - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GFC_G_MARSHALL_HH
#define GFC_G_MARSHALL_HH

#ifndef __GLIB_GOBJECT_H__
#include <glib-object.h>
#endif

namespace GFC {

namespace G {

// G::Marshal provides the common signal callback functions used by GTK+ Objects
// to translate GObject signal notifications into sigc::slot calls.

class Marshal
{
public:
	static void void_callback(void*);

	static void void_bool_callback(void*, bool);

	static void void_int_callback(void*, int);

	static void void_int_int_callback(void*, int, int);

	static void void_int_int_int_int_callback(void*, int, int, int, int);

	static void void_gparamspec_callback(void*, GParamSpec*);
};

} // namespace G

} // namespace GFC

#endif // GFC_G_MARSHALL_HH

