/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/// @file gfc/gtk/actionsignals.hh
/// @brief Gtk::Action virtual signal handlers.
///
/// Provides Gtk::ActionSignals, an abstract base class that implements
/// the overridable virtual signal handlers for Gtk::Action objects.

#ifndef GFC_GTK_ACTION_SIGNALS_HH
#define GFC_GTK_ACTION_SIGNALS_HH

#ifndef GFC_G_OBJECT_SIGNALS_HH
#include <gfc/glib/objectsignals.hh>
#endif

namespace GFC {

namespace Gtk {

/// @class ActionSignals actionsignals.hh gfc/gtk/actionsignals.hh
/// @brief Abstract base class that implements the virtual signal handlers for Gtk::Action.

class ActionSignals : public G::ObjectSignals
{
protected:
/// @name Constructors
/// @{

	ActionSignals(Action *action);
	///< Construct a new ActionSignals object.
	///< @param action An Action object inheriting the ActionSignals implementation.

	virtual ~ActionSignals() = 0;
	///< Destructor.

/// @}

public:
/// @name Signal Handlers
/// @{

	virtual void on_activate();
	///< Called when the action is activated.

/// @}
};

} // namespace Gtk

} // namespace GFC

#endif // GFC_GTK_ACTION_SIGNALS_HH

