// MM1RBN.H : ribbons for mm1-models.

// Copyright (C) 1998 Tommi Hassinen, Jarno Huuskonen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef MM1RBN_H
#define MM1RBN_H

#ifdef ENABLE_GRAPHICS

class mm1_ribbon;

/*################################################################################################*/

class spline;	 	// spline.h
class mm1_docv;		// mm1docv.h

#include "docview.h"
#include "objects.h"

/*################################################################################################*/

class mm1_ribbon : public smart_object
{
	public:
	
	mm1_docv * docv;
	color_mode * cmode;
	
	i32s extra_points;
	i32s chn; i32s length;
	
	fGL_a3 * cp1;		// control points
	fGL_a3 * cp2;		// control points
	
	spline * ref1;
	fGL_a3 * head_refs1[2];
	fGL_a3 * head_points1;
	fGL_a3 * tail_refs1[2];
	fGL_a3 * tail_points1;
	
	spline * ref2;
	fGL_a3 * head_refs2[2];
	fGL_a3 * head_points2;
	fGL_a3 * tail_refs2[2];
	fGL_a3 * tail_points2;
	
	fGL * data1;		// places of the control points in spline
	fGL_a3 * data2a;	// coordinates calculated using the spline
	fGL_a3 * data2b;	// coordinates calculated using the spline
	fGL_a3 * data3;		// colors of the points
	
	iGLu list_id;
	
	static const i32s resol;
	
	static const fGL width;
	static const fGL helix;
	
	public:
	
	mm1_ribbon(mm1_docv *, color_mode *, i32s, i32s);
	~mm1_ribbon(void);
	
	void MakeRibbon(void);
	void UpdateExtraPoints(fGL_a3 **, fGL_a3 *, fGL_a3 **, fGL_a3 *);
	
	const char * GetObjectName(void) { return "Ribbon"; }		// virtual

	void CameraEvent(const camera &) { }	// virtual
	
	bool BeginTransformation(void) { return false; }	// virtual
	bool EndTransformation(void) { return false; }		// virtual
	
	void Render(void);		// virtual
};

/*################################################################################################*/

#endif	// ENABLE_GRAPHICS
#endif	// MM1RBN_H

// eof
