// MM3DOCV.CPP

// Copyright (C) 2000 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "mm3docv.h"

#ifdef ENABLE_GRAPHICS
#include "plane.h"
#include "surface.h"

#include "color.h"
#include "views.h"

#include "mm2mdl.h"

#include <fstream>
#include <strstream>
using namespace std;

/*################################################################################################*/

mm3_docv::mm3_docv(ostream * p1, graphics_class_factory & p2) :
	docview(p1, p2), mm3_mdl(p1, p2), model_simple(p1, p2)
{
}

mm3_docv::~mm3_docv(void)
{
}

fGL mm3_docv::GetDefaultFocus(void)
{
	return 5.0;
}

const char * mm3_docv::GetType(void)
{
	return "MM, ?????";
}

color_mode * mm3_docv::GetDefaultColorMode(void)
{
	return NULL;
}

void mm3_docv::SelectAll(void)
{
}

void mm3_docv::InvertSelection(void)
{
}

// it seems that there is something common for all models (like the sel-buffer) -> move to the bs_docv?!?!
// it seems that there is something common for all models (like the sel-buffer) -> move to the bs_docv?!?!
// it seems that there is something common for all models (like the sel-buffer) -> move to the bs_docv?!?!

void mm3_docv::InitGL(void)
{
	glClearColor(0.0, 0.0, 0.0, 1.0);
	glDepthFunc(GL_LESS); glEnable(GL_DEPTH_TEST);
	
	glMateriali(GL_FRONT_AND_BACK, GL_SHININESS, 64);
	const fGL specular_reflectance[4] = { 0.9, 0.9, 0.9, 1.0 };
	glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, specular_reflectance);
	glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
	glEnable(GL_COLOR_MATERIAL);
	
	const fGL ambient_intensity[4] = { 0.2, 0.2, 0.2, 1.0 };
	glLightModelfv(GL_LIGHT_MODEL_AMBIENT, ambient_intensity);
	glLightModeli(GL_LIGHT_MODEL_LOCAL_VIEWER, true);
	
	glFogi(GL_FOG_MODE, GL_EXP); glFogf(GL_FOG_DENSITY, 0.15);
	const fGL fog_color[4] = { 0.0, 0.0, 0.0, 0.0 };
	glFogfv(GL_FOG_COLOR, fog_color);
	
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	
	glSelectBuffer(SB_SIZE, select_buffer);
}

void mm3_docv::Render(graphics_view * gv, rmode rm)
{
	bool accum = gv->accumulate; if (rm != Normal) accum = false;
	
	if (accum) { glClear(GL_ACCUM_BUFFER_BIT); }
	else if (rm != Transform2) glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	
	if (gv->enable_fog) glEnable(GL_FOG);
	
	glEnable(GL_LIGHTING);
	
	for (i32u n1 = 0;n1 < chn_vector.size();n1++)
	{
		for (i32u n2 = 0;n2 < chn_vector[n1].sse_vector.size();n2++)
		{
			fGL radius; fGL length;
			switch (chn_vector[n1].sse_vector[n2].type)
			{
				case mm3_sse::helix:
				glColor3f(1.0, 0.0, 0.0); radius = 0.25;
				length = 0.125 * chn_vector[n1].sse_vector[n2].residues;
				break;
				
				case mm3_sse::strand:
				glColor3f(0.0, 1.0, 0.0); radius = 0.10;
				length = 0.275 * chn_vector[n1].sse_vector[n2].residues;
				break;
				
				default:
				cout << "problem in mm3_docv::Render()" << endl;
				exit(EXIT_FAILURE);
			}
			
			v3d<fGL> v1(chn_vector[n1].sse_vector[n2].center);
			v3d<fGL> v2(chn_vector[n1].sse_vector[n2].direction);
			v3d<fGL> v3 = v1 - (v2 * (length * 0.5));
			
			fGL pol[3]; crt2pol(chn_vector[n1].sse_vector[n2].direction, pol);
			
			const i32s resolution = 12;
			GLUquadricObj * qo = gluNewQuadric();
			gluQuadricDrawStyle(qo, (GLenum) GLU_FILL); glPushMatrix();
			
			glTranslated(v3[0], v3[1], v3[2]);
			
			glRotated(180.0 * pol[1] / M_PI, 0.0, 1.0, 0.0);
			glRotated(180.0 * pol[2] / M_PI, sin(-pol[1]), 0.0, cos(-pol[1]));
			
		//	gluCylinder(qo, radius, radius, length, resolution, resolution / 2);
			gluCylinder(qo, radius*1.2, radius/1.2, length, resolution, resolution / 2);	// this will show direction...
			
			glPopMatrix(); gluDeleteQuadric(qo);
		}
	}
	
	glDisable(GL_LIGHTING);
	
	if (accum) glAccum(GL_RETURN, 1.0);
	else if (rm != Transform2) gv->cam->RenderObjects(gv);
	
	if (gv->enable_fog) glDisable(GL_FOG);
	
	// finally call this to handle transparency...
	// finally call this to handle transparency...
	// finally call this to handle transparency...
	
	RenderAllTPs(gv, rm);
}

//void mm3_docv::DrawCylinder(???)
//{
//}

void mm3_docv::Center(transformer *)
{
}

void mm3_docv::Transform(transformer *)
{
}

void mm3_docv::DrawEvent(graphics_view *, vector<iGLu> &)
{
}

void mm3_docv::EraseEvent(graphics_view *, vector<iGLu> &)
{
}

void mm3_docv::SelectEvent(graphics_view *, vector<iGLu> &)
{
}

void mm3_docv::MeasureEvent(graphics_view *, vector<iGLu> &)
{
}

void mm3_docv::ProcessCommandString(graphics_view * gv, const char * command)
{
	char mbuff1[512];
	ostrstream str1(mbuff1, sizeof(mbuff1));
	str1 << "Processing Command : " << command << endl << ends;
	PrintToLog(mbuff1);
	
	bool retval = ProcessCommonCommands(gv, command);
	if (retval == true) return;
	
	istrstream istr(command);
	char kw1[32]; istr >> kw1;
	
	// is it "help"??? if is, then append...
	
	if (!strcmp("help", kw1))
	{
		return;
	}
	
	// process other commands.
	// process other commands.
	// process other commands.
	
	if (!strcmp("add", kw1))
	{
		char kw2[32]; istr >> kw2;	// the 2nd keyword; type of the object to add.
		
		PrintToLog("ERROR : could not process a command : \"add\".\n");
	}
	
	// error message...
	ostrstream strE(mbuff1, sizeof(mbuff1)); strE << "ERROR : Unknown command : " << command << endl << ends;
	PrintToLog(mbuff1); PrintToLog("The \"help\" command will give more information about command strings.\n");
}

/*################################################################################################*/

#endif	// ENABLE_GRAPHICS

// eof
