// QM1DOCV.H : a graphical user interface for qm1-models.

// Copyright (C) 2000 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef QM1DOCV_H
#define QM1DOCV_H

#ifdef ENABLE_GRAPHICS

class qm1_docv;

class qm1_cm_element;		// mm1_atom *

/*################################################################################################*/

#include "docview.h"
#include "qm1mdl.h"

#include <list>
using namespace std;

/*################################################################################################*/

class qm1_docv : virtual public docview, public qm1_mdl
{
	protected:
	
	public:
	
	static qm1_cm_element cm_element;	// color mode...
	qm1_atom * draw_data[2];	// why public??? looks bad.
	
	public:
	
	qm1_docv(ostream *, graphics_class_factory &);
	virtual ~qm1_docv(void);
	
	/**	This will properly delete the current engine.
		
		If we are going to trash the current engine, we must also trash all objects 
		(planes/surfaces) that are dependent on it. And we must take care that the 
		selected object remains valid...
	*/
	
	void DiscardCurrentEng(void);		// virtual
	void SetupPlotting(void);		// virtual
	
	fGL GetDefaultFocus(void);		// virtual
	
	const char * GetType(void);			// virtual
	color_mode * GetDefaultColorMode(void);		// virtual
	
	void SelectAll(void);				// virtual
	void InvertSelection(void);			// virtual
//	void SelectNone(void);				// virtual	// see the base class...
	
	bool TestAtom(qm1_atom *, rmode);
	void SetColor(color_mode *, qm1_atom *);
	
	void Render(graphics_view *, rmode);		// virtual
	
	void Center(transformer *);			// virtual
	void Transform(transformer *);			// virtual
	
	void DrawEvent(graphics_view *, vector<iGLu> &);	// virtual
	void EraseEvent(graphics_view *, vector<iGLu> &);	// virtual
	void SelectEvent(graphics_view *, vector<iGLu> &);	// virtual
	void MeasureEvent(graphics_view *, vector<iGLu> &);	// virtual
	
	enlevdiag_view * AddEnLevDiagView(void);
	
	void ProcessCommandString(graphics_view *, const char *);	// virtual
};

/*################################################################################################*/

class qm1_cm_element : public color_mode
{
	protected:
	
	public:
	
	qm1_cm_element(void) : color_mode() { }
	~qm1_cm_element(void) { }
	
	void GetColor(const void *, fGL_a4 &, prefs *p = 0);
};

/*################################################################################################*/

#endif	// ENABLE_GRAPHICS
#endif	// QM1DOCV_H

// eof
