// T3DOCV.H : a GNOME "document/view"-style base class.

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#ifndef T3DOCV_H
#define T3DOCV_H

class gnome_docv;

/*################################################################################################*/

class graphics_view;		// views.h
class treelist_view;		// views.h
class view_factory;		// views.h

#include "docview.h"
#include "t3views.h"

#include <gtk/gtk.h>
#include <gnome.h>

#include <vector>
using namespace std;

/*################################################################################################*/

/**	This will contain GNOME-dependent aspects of the "##docview" class.

	A gnome_docv object will hold a pointer to GnomeMDIGenericChild; so, it will hold
	the gnome MDI child features.
	
	The another side, the gnome MDI view, is handled as follows: there is only a single
	view, which is a GtkNotebook object. This is a container object that can hold other
	GtkWidgets. So there is only a single MDI view for an MDI child.
*/

class gnome_docv : virtual public docview
{
	protected:
	
	GnomeMDIGenericChild * child;
	
	GtkWidget * paned_widget;
	GtkWidget * notebook;
	//GtkTextBuffer * log_buffer;	// in GTK2
	GtkWidget * scroll_widget; GtkWidget * log_widget; int logpos;
	
	GtkWidget * popupmenu;
	
	friend class gnome_class_factory;
	
	friend class gnome_ogl_view;
	friend class gnome_treelist_view;
	
	friend class gnome_view;
	friend class gnome_graphics_view;
	friend class gnome_qm1_docv;	// soon to be obsolete???
	friend class gnome_mm1_docv;	// soon to be obsolete???
//	friend class gnome_mm2_docv;	// is obsolete
	
	friend class qm1_file_open_dialog;
	friend class qm1_file_save_dialog;
	friend class mm1_file_open_dialog;
	friend class mm1_file_save_dialog;
	
	friend class mm2_file_open_dialog;
	friend class mm2_file_save_dialog;
	
	public:
	
	// this all is for the glade dialogs.
	// nothing very carefully thought, but still a start...
	
	static gnome_docv * glade_modal_dialog_owner;
	
	public:
	
	gnome_docv(ostream *, gnome_class_factory &);
	virtual ~gnome_docv(void);
	
	void InitGnomeMDIChild(void);	// BE VERY CAREFUL WITH THIS!!!
	
	static char * GetConfigString(GnomeMDIChild * child, gpointer);
	static GtkWidget * GnomeViewCreator(GnomeMDIChild * child, gpointer);
	
	void UpdateAllWindowTitles(void);		// virtual
	void event_SelectedObjectChanged(void);		// virtual
	
	void PrintToLog(const char *);			// virtual
};

/*################################################################################################*/

#endif	// T3DOCV_H

// eof
