/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * See the COPYING file for license information.
 *
 * Guillaume Chazarain <guichaz@yahoo.fr>
 */

/***************************************************************
 * getdelim() is a GNU extension so here is an implementation. *
 ***************************************************************/

#include <stdlib.h>             /* malloc(), realloc() */
#include <string.h>             /* strchr() */
#include "./getdelim.h"

/* We don't handle errno. */

ssize_t getdelim(char **lineptr, size_t * n, int delim, FILE * stream)
{
    size_t buf_size, real_size = 0;
    char *buf;
    int c;

    if (!n || !lineptr || !stream || feof(stream))
        return -1;

    /* Initialize the buffer. */
    if (*lineptr == NULL || *n == 0) {
        buf_size = 128;
        buf = malloc(buf_size);
    } else {
        buf_size = *n;
        buf = *lineptr;
    }

    do {
        if (real_size == buf_size) {
            /* Buffer too small, enlarge it. */
            buf_size *= 2;
            buf = realloc(buf, buf_size);
        }

        c = getc(stream);

        buf[real_size] = (char) c;
        real_size++;

    } while (c != delim && c != EOF);

    if (c == delim)
        /* We keep the delimiter. */
        real_size++;

    buf = realloc(buf, real_size + 1);
    buf[real_size] = '\0';

    *lineptr = buf;
    *n = real_size + 1;

    return (ssize_t) real_size;
}
