/******************************************************************************\
 gnofin/numeric-parser.c   $Revision: 1.6 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#include "common.h"
#include <stdlib.h>
#include <limits.h>
#include <ctype.h>
#include <math.h>
#include "numeric-parser.h"

gboolean
int_parse (const gchar *text, gint *val)
{
  long int n;
  char *p;

  g_return_val_if_fail (text, FALSE);
  g_return_val_if_fail (val, FALSE);

  if (text [0] == '\0')
  {
    trace ("no chars to convert!");
    return FALSE;
  }

  n = strtol (text, &p, 10);

  if (p == text)
  {
    trace ("no chars converted!");
    return FALSE;
  }
  if (strlen (p) > 0)
  {
    trace ("not all chars converted!");
    return FALSE;
  }
  if ((n == LONG_MAX) || (n == LONG_MIN))
    g_print ("Warning: number has been clamped!\n");

  *val = (gint) n;
  
  return TRUE;
}

gboolean
uint_parse (const gchar *text, guint *val)
{
  long int n;
  char *p;

  g_return_val_if_fail (text, FALSE);
  g_return_val_if_fail (val, FALSE);

  if (text [0] == '\0')
  {
    trace ("no chars to convert!");
    return FALSE;
  }

  n = strtol (text, &p, 10);

  if (p == text)
  {
    trace ("no chars converted!");
    return FALSE;
  }
  if (strlen (p) > 0)
  {
    trace ("not all chars converted!");
    return FALSE;
  }
  if ((n == LONG_MAX) || (n == LONG_MIN))
    g_print ("Warning: number has been clamped!\n");
  if (n < 0)
    g_print ("Warning: ignoring negative sign in front of number!\n");

  *val = (guint) labs (n);
  
  return TRUE;
}

gboolean
float_parse (const gchar *text, gfloat *val)
{
  double d;
  char *p;

  g_return_val_if_fail (text, FALSE);
  g_return_val_if_fail (val, FALSE);

  if (text [0] == '\0')
  {
    trace ("no chars to convert!");
    return FALSE;
  }

  d = strtod (text, &p);

  if (p == text)
  {
    trace ("no chars converted!");
    return FALSE;
  }
  if (strlen (p) > 0)
  {
    trace ("not all chars converted!");
    return FALSE;
  }
  if ((d == HUGE_VAL) || (d == HUGE_VAL))
    g_print ("Warning: number has been clamped!\n");

  *val = (gfloat) d;

  return TRUE;
}

#ifdef G_HAVE_GINT64
gboolean
int64_parse (const gchar *text, gint64 *val)
{
  gint64 buf = 0;

  g_return_val_if_fail (text, FALSE);
  g_return_val_if_fail (val, FALSE);

  for (; *text; ++text)
  {
    if (isdigit (*text))
      buf = ((gint64)(*text - '0')) + 10*buf;
    else
      return FALSE;
  }

  *val = buf;
  return TRUE;
}
#endif
