/******************************************************************************\
 gnofin/trace.h   $Revision: 1.2 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef TRACE_H
#define TRACE_H

GNOFIN_API_BEGIN

/* tracing program execution... better than printf */
void real_trace(const char *,char *,...);

#ifdef ENABLE_DEBUG_TRACE
# define trace(fmt, args...) real_trace(__PRETTY_FUNCTION__, fmt, ## args)
#else
# define trace(fmt, args...) 
#endif

GNOFIN_API_END

#endif

// vim: ts=8 sw=2
