/** -*- Mode: C++; tab-width: 4 -*-
 * vim: sw=4 ts=4:
 *
 * Gnome Apt filter class
 *
 * 	(C) 1998 Havoc Pennington <hp@pobox.com>
 * 	    2003 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

#ifndef GNOME_APT_FILTER_H
#define GNOME_APT_FILTER_H

#include "cache.h"

#include <map>
#include <set>

class GAptCache;
typedef struct _GAptSearch GAptSearch;

class Filter {
public:
  Filter();
  ~Filter() {}

  bool include_package(pkgCache::PkgIterator & i, GAptCache* cache);

  void reverse_entire_filter(); // show opposite set of packages
  void clear_entire_filter();   // permit all packages

  // change_notify should be true for outside use, 
  //  it's false internally when we want to do several
  //  operations at once.
	void set_status_filter (GAptCache::PkgStatusType, bool);
  void reverse_status_filter(bool change_notify = true); 
  void clear_status_filter(bool change_notify = true);

  void set_priority_filter(pkgCache::State::VerPriority p, bool state);
  void reverse_priority_filter(bool change_notify = true);
  void clear_priority_filter(bool change_notify = true);

	void set_search_filter (GAptSearch*);
	bool get_search_filter (pkgCache::Package*);

	bool get_status_filter (GAptCache::PkgStatusType) const;
  bool get_priority_filter(pkgCache::State::VerPriority p) const;

  class View {
  public:
    virtual void filter_changed() = 0;
  };

  void add_view(View* v);
  void remove_view(View* v);

	void change_notify (void);
private:
  // by setting the defaults, we avoid having to 
  //  care what the possible enum values are; 
  //  for things not found in the map, we just 
  //  return the default, which can be reversed.
	map<GAptCache::PkgStatusType, bool> status_;
  bool status_default_; 
  map<pkgCache::State::VerPriority,bool> priority_;
  bool priority_default_;

	GAptSearch* f_search;

  set<View*> views_;
};

#endif
