/*  Gnometab -- a guitar tablature editor for GNOME
    Copyright (C) 2001  William L. Guelker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

typedef struct _GtabDialogSlur          GtabDialogSlur;
typedef struct _GtabDialogBar           GtabDialogBar;
typedef struct _GtabDialogStrum         GtabDialogStrum;
typedef struct _GtabDialogProps         GtabDialogProps;    
typedef struct _GtabDialogTimesig       GtabDialogTimesig;    
typedef struct _GtabDialogComment       GtabDialogComment;
typedef struct _GtabDialogRest          GtabDialogRest;
typedef struct _GtabDialogPrefs         GtabDialogPrefs;
    
struct _GtabDialogSlur {
    GtabDoc             *tab_doc;
    GtkWidget           *dialog;
    GtkWidget           *spin_slur_length;
    GtkWidget           *radio_hammer;
    GtkWidget           *radio_pulloff;
    GtkWidget           *radio_slide;
    GtkWidget           *radio_trill;
    double              x;
    double              y;
};

struct _GtabDialogBar {
    GtabDoc             *tab_doc;
    GtkWidget           *dialog;
    GtkWidget           *spin_bar_size;
    double              x;
    double              y;
};

struct _GtabDialogStrum {
    GtabDoc             *tab_doc;
    GtkWidget           *dialog;
    GtkWidget           *spin_strum_size;
    GtkWidget           *radio_down;
    GtkWidget           *radio_up;
    double              x;
    double              y;
};

struct _GtabDialogProps {
    GtabDoc             *tab_doc;
    GtkWidget           *dialog;
    GtkWidget           *title;
    GtkWidget           *artist;
    GtkWidget           *tuning;
};

struct _GtabDialogTimesig {
    GtabDoc             *tab_doc;
    GtkWidget           *dialog;
    GtkWidget           *beats;
    GtkWidget           *beatval;
    double              x;
    double              y;
};

struct _GtabDialogComment {
    GtabDoc             *tab_doc;
    GtkWidget           *dialog;
    GtkWidget           *comment;
    double              x;
    double              y;
};

struct _GtabDialogRest {
    GtabDoc             *tab_doc;
    GtkWidget           *dialog;
    GtkWidget           *length;
    GtkWidget           *dotted;
    double              x;
    double              y;
};

struct _GtabDialogPrefs {
    GtabApp             *app;
    GtkWidget           *dialog;
    GtkWidget           *current_chord_lib;
    GtkWidget           *chords_above_staff;
    GtkWidget           *tab_font;
    GtkWidget           *tab_font_large;
    GtkWidget           *tab_font_small;
    GtkWidget           *tab_font_tiny;
    GtkWidget           *chrd_bldr_font;
    GtkWidget           *chrd_bldr_font_small;
    gboolean            lib_is_changed;
    gboolean            font_is_changed;
    gboolean            cas_is_changed;
};

/* tab object dialogs */

GtabDialogSlur*         
create_slur_length_popup        (GtabDoc     *doc);

GtabDialogBar*          
create_bar_size_popup           (GtabDoc     *doc);

GtabDialogBar*          
create_chord_bar_size_popup     (GtabChordBuilder *chord_dialog);

GtabDialogStrum*        
create_strum_size_select        (GtabDoc     *doc);

GtabDialogProps*        
create_props_popup              (GtabDoc     *doc);

GtabDialogTimesig*      
create_timesig_popup            (GtabDoc     *doc);

GtabDialogComment*      
create_comment_popup            (GtabDoc     *doc);

GtabDialogRest*         
create_rest_popup               (GtabDoc     *doc);

GtabDialogPrefs*        
create_prefs_popup              (GtabApp     *app);

/* file selection dialogs */

GtkWidget*              
create_file_load_select         (GtabDoc *doc);

GtkWidget*              
create_lib_select               (GtabApp *app, gchar *title);

/* utility */
void                    
gtab_warn                       (GtabApp *app, const gchar *warning);
