// -*- c++ -*-

//  Gnomoradio - gnomoradio/criteria-input.h
//  Copyright (C) 2004  Matt Gerginski
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __CRITERIA_INPUT_H
#define __CRITERIA_INPUT_H

#include <gtkmm.h>
#include <libxml++/document.h>

namespace Gnomoradio
{
	/* This class will allow the input of one criteria for *
	 * use in the CriteriaCreator                          */
	class CriteriaInput : public Gtk::HBox
	{
	public:
		CriteriaInput ();
		virtual ~CriteriaInput ();

		sigc::signal<void> signal_remove_clicked;
		sigc::signal<void> signal_changed;
		
		/* adds the criteria to parent node */
		void add_criteria (xmlpp::Node *parent);

		/* returns the xml neccessary for creating a searchlist *
		 * using this input as the sole criteria                */
		Glib::ustring get_criteria ();
		void set_criteria (xmlpp::Element *element);

	protected:
		Gtk::Button remove;

		Gtk::OptionMenu category, constraint, time_units;
		
		Gtk::Menu category_menu;
		Gtk::MenuItem any_field, artist, title, album, length, rating, last_played;
		
		Gtk::Menu info_menu, rating_menu, length_menu, last_played_menu;
		Gtk::MenuItem contains, higher_than, equal_to, lower_than, more_than, less_than, shorter_than, longer_than; 

		Gtk::Menu time_units_menu;
		Gtk::MenuItem minutes, hours, days, weeks;

		Gtk::Entry entry;
		Gtk::SpinButton spin;
		Gtk::Adjustment rating_adj, length_adj, last_played_adj;
		Gtk::Label ending_label;

		virtual void on_show();
		virtual void show_all_vfunc() { on_show(); }

		void on_remove_clicked ();

		/* updates which widgets are displayed */
		void update ();

		void emit_changed_signal () { signal_changed.emit(); }
	};
}

#endif
