//  Gnomoradio - gnomoradio/song-info.cc
//  Copyright (C) 2003  Matt Gerginski
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "song-info.h"
#include "song-rater.h"

#include <sstream>

using namespace Gtk;
using namespace Glib;
using namespace Wraporadio;
using namespace std;

Gnomoradio::SongInfoBox::SongInfoBox (const Wraporadio::Song &song)
	: cancel_button(Stock::CANCEL),
	  ok_button(Stock::OK),
	  rating(song->get_rating(), -3, 3)
{
	vector<ustring> key, value;
	int hash_size;
	int rows; // number of rows in table

	box_song = song;

	/* some initial values for the window */
	set_title(_("Edit Song Info"));
	set_resizable(false);
	set_border_width(10);

	box_song->get_info(key, value);

	hash_size = key.size();

	Table *table = manage(new Table(hash_size + 2, 2, FALSE)); // two extra rows for buttons and rating
	add(*table);

	/* box will always at least have artist, title, and album */
	for (int i = 0; i <= 2; i++)
	{
		labels.push_back(manage(new Label));
		entries.push_back(manage(new Entry));

		entries[i]->signal_changed().connect(sigc::mem_fun(*this, &Gnomoradio::SongInfoBox::ok_button_set_sensitive));

		table->attach(*labels[i],  0, 1, i, i+1);
		table->attach(*entries[i], 1, 2, i, i+1);
	}

	entries[0]->set_text(song->get_info("artist"));
	entries[1]->set_text(song->get_info("title"));
	entries[2]->set_text(song->get_info("album"));

	labels[0]->set_text("artist");
	labels[1]->set_text("title");
	labels[2]->set_text("album");

	rows = 3;

	/* Add entries for any additional information */
	for (int i = 0; i < hash_size; ++i)
	{
		if (!((key[i] == "title") || (key[i] == "artist") || (key[i] == "album")))
		{
			entries.push_back(manage(new Entry));
			entries[rows]->set_text(value[i]);
			if (key[i] == "license")
				entries[rows]->set_editable(false);
			
			//key[i][0]  = toupper(key[i][0]);
			labels.push_back(manage(new Label(key[i])));
		
			table->attach(*labels[rows],  0, 1, rows, rows+1);
			table->attach(*entries[rows], 1, 2, rows, rows+1);

			entries[rows]->signal_changed().connect(sigc::mem_fun(*this, &Gnomoradio::SongInfoBox::ok_button_set_sensitive));

			++rows;
		}
	}
	
	/* Add entry for URI */
	entries.push_back(manage(new Entry));
	labels.push_back(manage(new Label(_("URI"))));
	entries[rows]->set_text(song->get_url());
	entries[rows]->set_editable(false);
	table->attach(*labels[rows],  0, 1, rows, rows+1);
	table->attach(*entries[rows], 1, 2, rows, rows+1);
	++rows;

	/* length of song */
	if (song->get_length()) {
		entries.push_back(manage(new Entry));
		labels.push_back(manage(new Label(_("Length"))));
		ostringstream len;
		// FIXME: it wouldn't hurt to localize this
		len << (song->get_length() / 60) << ':';
		len.width(2);
		len.fill('0');
		len << (song->get_length() % 60);
		entries[rows]->set_text(len.str());
		entries[rows]->set_editable(false);
		table->attach(*labels[rows],  0, 1, rows, rows+1);
		table->attach(*entries[rows], 1, 2, rows, rows+1);
		++rows;
	}

	/* set-up and pack rating */
	rating.signal_value_changed.connect(sigc::mem_fun(*this, &Gnomoradio::SongInfoBox::ok_button_set_sensitive));

	Label *rating_label = manage(new Label(_("Rating")));
	
	table->attach(*rating_label, 0, 1, rows, rows+1);
	table->attach(rating, 1, 2, rows, rows+1);

	++rows;

	/* pack buttons */
	HBox *button_hbox = manage(new HBox(FALSE, 5));

	button_hbox->pack_start(cancel_button, PACK_EXPAND_PADDING);
	button_hbox->pack_start(ok_button, PACK_EXPAND_PADDING);

	table->attach(*button_hbox, 0, 2, rows, rows+1);

	/* make table look pretty */
	table->set_row_spacings(5);
	table->set_col_spacings(5);
	table->set_row_spacing(rows-1, 15);

	/* connect button signals */
	ok_button.signal_clicked().connect(sigc::mem_fun(*this, &Gnomoradio::SongInfoBox::on_ok_clicked));
	cancel_button.signal_clicked().connect(sigc::mem_fun(*this, &Gnomoradio::SongInfoBox::on_cancel_clicked));

	ok_button.set_sensitive(FALSE);

	signal_hide().connect(sigc::mem_fun(*this, &Gnomoradio::SongInfoBox::on_hide));
}


Gnomoradio::SongInfoBox::~SongInfoBox ()
{

}

void Gnomoradio::SongInfoBox::on_hide_signal ()
{
	delete this;
}

void Gnomoradio::SongInfoBox::on_cancel_clicked ()
{
	hide();
}

void Gnomoradio::SongInfoBox::on_ok_clicked ()
{
	ustring key;

	for (int i = 0; i < entries.size(); i++)
	{
		key = labels[i]->get_text();
		
		if (key == _("URI")
		    || key == _("Length"))
			continue; // maybe we should just not put these in the array

		//key[0] = tolower(key[0]);

		if (key == "license")
			continue;

		box_song->set_info(key, entries[i]->get_text());
	}

	box_song->set_rating((int) rating.get_value());

	hide();
}

void Gnomoradio::SongInfoBox::ok_button_set_sensitive ()
{
	ok_button.set_sensitive();
}
