//  Gnomoradio - roboradio/song-list-automatic.cc
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "song-list-automatic.h"
#include "song-rainbow.h"
#include "sort-songs.h"

using namespace Roboradio;
using namespace std;

Roboradio::SongListAutomatic::SongListAutomatic (const Glib::ustring &title)
	: SongListMutable(title)
{
	do_upcoming_ref = false;

	Song::signal_global_new_song.connect(mem_fun(*this, &SongListAutomatic::new_song));
}

Roboradio::SongListAutomatic::~SongListAutomatic ()
{
}

bool Roboradio::SongListAutomatic::destroyable ()
{
	return false;
}

void Roboradio::SongListAutomatic::new_song (SongRef song)
{
	if (meets_criteria(song))
		push_back(song);
}

void Roboradio::SongListAutomatic::construct ()
{
	SortSongs sort(SortSongs::Artist);
	for (SortSongs::iterator s = sort.begin(); s != sort.end(); ++s)
		if (meets_criteria(*s))
			push_back(*s);
}
