/**
 ** dir_list.c - routines to deal with the additional dir songs list
 **
 ** Copyright (C) 2000 Matthew Pratt <mattpratt@yahoo.com>
 **
 ** This software is licensed under the terms of the GNU General 
 ** Public License (GPL). Please see the file LICENSE for details.
 **/ 

#include "gnomp3.h"
#include "mp3list.h"

/*
 * Callback for the mp3list search. Given mp3 is added to the dir_clist
 * and is colours set approriately
 */
void dir_list_add(MP3 *mp3)
{
    char *col[2];
    int n;

    col[0] = mp3->display_name;
    col[1] = mp3list_build_time(mp3);
    n = gtk_clist_append( GTK_CLIST(gnomp3.dir_clist), col);
    gtk_clist_set_row_data( GTK_CLIST(gnomp3.dir_clist), n, mp3);
    mp3->row_dirlist = n;
    if(mp3->row_playlist >= 0){
	gtk_clist_set_background( GTK_CLIST(gnomp3.dir_clist), n,
 				  &gnomp3.in_playlist_bg_color);
	gtk_clist_set_foreground( GTK_CLIST(gnomp3.dir_clist), n,
 				  &gnomp3.in_playlist_fg_color);
    }
}

/*
 * Clear and add songs to the additional dir list by searching the entire
 * mp3list for the additional dir path
 */ 
void dir_list_build()
{
    gtk_clist_freeze( GTK_CLIST(gnomp3.dir_clist));
    gtk_clist_clear( GTK_CLIST(gnomp3.dir_clist));
    
    mp3list_search_by_name( gnomp3.add_song_dir, dir_list_add );
    
    gtk_clist_thaw( GTK_CLIST(gnomp3.dir_clist));
}



