# GNU Enterprise Datasource Library - Driver for GNUe-AppServer
#
# Copyright 2000-2005 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: DataObject.py 6894 2005-01-13 15:11:08Z johannes $

from types import *

import string

from gnue.common.datasources import GConditions
from gnue.common.datasources.drivers import Base

import ResultSet

# =============================================================================
# DataObject class
# =============================================================================

class DataObject (Base.DataObject):
  """
  Handles a dataobject in the GNUe-AppServer backend.
  """
  # This is actually never used
  _resultSetClass = ResultSet.ResultSet

  # ---------------------------------------------------------------------------
  # Build query in prefix notation
  # ---------------------------------------------------------------------------

  def _buildQuery (self, conditions = {}, forDetail = None,
                   additionalSQL = ''):

    if isinstance (conditions, DictType):
      cond = GConditions.buildConditionFromDict (conditions)
    else:
      cond = conditions

    query = cond.prefixNotation ()

    return query

  # ---------------------------------------------------------------------------
  # Create an empty resultset
  # ---------------------------------------------------------------------------

  def _createEmptyResultSet (self, readOnly = 0, masterRecordSet = None):

    fieldlist = self._fieldReferences.keys ()

    return ResultSet.ResultSet (dataObject      = self,
                                sm              = self._connection._sm,
                                session_id      = self._connection._sess_id,
                                list_id         = None,
                                classname       = self.table,
                                fieldlist       = fieldlist,
                                fetchcount      = self.cache,
                                readOnly        = readOnly,
                                masterRecordSet = masterRecordSet)

  # ---------------------------------------------------------------------------
  # Create a resultset
  # ---------------------------------------------------------------------------

  def _createResultSet (self, conditions = {}, readOnly = 0,
                        masterRecordSet = None, sql = ''):

    if conditions is not None:
      filter = self._buildQuery (conditions)
    else:
      filter = []

    sort      = self.sorting and self.sorting or []
    fieldlist = self._fieldReferences.keys ()

    list_id = self._connection._sm.request (self._connection._sess_id,
                                            self.table, filter, sort, fieldlist)

    return ResultSet.ResultSet (dataObject      = self,
                                sm              = self._connection._sm,
                                session_id      = self._connection._sess_id,
                                list_id         = list_id,
                                classname       = self.table,
                                fieldlist       = fieldlist,
                                fetchcount      = self.cache,
                                readOnly        = readOnly,
                                masterRecordSet = masterRecordSet)

  # ---------------------------------------------------------------------------
  # debug method: dump a complete condition tree 
  # ---------------------------------------------------------------------------

  def __dumpTree (self, element, level = 0):
    print "%2d: %s (%s) [%s]" % (level, element.__class__, hex(id(element)), 
                            hex(id(element._parent)))
    nlevel = level + 1
    print "  -> %s" % [hex (id (x)) for x in element._children]

    for ch in element._children:
      self.__dumpTree (ch, nlevel)
