#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# Parser.py
#
# DESCRIPTION:
# Class that implements the GParser XML parser framework for GNUe RPC.
#
# NOTES:
#


from gnue.common.definitions import GParser

import copy, types
from gnue.common.formatting import GTypecast






########
########  Please keep this file neat !!!
########






#######################################################
# This method loads a form from an XML file and returns
# a GFForm object.  If initialize is 1 (default), then
# the form is initialized and ready to go.
#
# (initialize=0 is currently not used -- will probably
#  be used in the Forms Designer package where we will
#  not want the loaded form to connect to databases, etc)
#######################################################

def loadDefinition(URL, initialize=0):
  return GParser.loadXMLObject (URL, xmlHandler, "RpGnuRpc", 'gnurpc',
           initialize, attributes={})


xmlElements = None


def getXMLelements():

  global xmlElements

  if xmlElements == None:
    import Objects

    xmlElements = {
      'gnurpc': {
         'BaseClass': Objects.GnuRpc,
         'Required': 1,
#         'SingleInstance': 1,
         'ParentTags': None },

      'service': {
         'BaseClass': Objects.RpcService,
         'Required': 1,
         'Attributes': {
            'name': {
               'Typecast': GTypecast.name,
               'Required': 1 },
            'binding': {
               'Typecast': GTypecast.name }, 
            'helptext': {
               'Typecast': GTypecast.name } },
         'ParentTags': ('gnurpc','service') },

      'method': {
         'BaseClass': Objects.RpcMethod,
         'Required': 1,
#         'SingleInstance': 1,
         'Attributes': {
            'name': {
               'Typecast': GTypecast.name,
               'Required': 1 },
            'return': {
               'Typecast': GTypecast.name },
            'helptext': {
               'Typecast': GTypecast.name } },
         'ParentTags': ('gnurpc','service','object') },

      'object': {
         'BaseClass': Objects.RpcObject,
#         'SingleInstance': 1,
         'Attributes': {
            'name': {
               'Typecast': GTypecast.name,
               'Required': 1 },
            'helptext': {
               'Typecast': GTypecast.name }}, 
         'ParentTags': ('gnurpc','service') },

      'argument': {
         'BaseClass': Objects.RpcArgument,
         'Attributes': {
            'name': {
               'Typecast': GTypecast.name,
               'Required': 1 },
            'type': {
               'Typecast': GTypecast.name,
               'Required': 1 },
            'default': {
               'Typecast': GTypecast.text },
            'helptext': {
               'Typecast': GTypecast.name } },
         'ParentTags': ('method',) },

      'attribute': {
         'BaseClass': Objects.RpcAttribute,
         'Attributes': {
            'name': {
               'Typecast': GTypecast.name,
               'Required': 1 },
            'type': {
               'Typecast': GTypecast.name,
               'Required': 1 },
            'readonly': {
               'Typecast': GTypecast.boolean,
               'Default': 0 },
            'writeonly': {
               'Typecast': GTypecast.boolean,
               'Default': 0 },
            'helptext': {
               'Typecast': GTypecast.name }  },
         'ParentTags': ('object',) },

      'exception': {
         'BaseClass': Objects.RpcException,
         'Attributes': {
            'name': {
               'Typecast': GTypecast.name,
               'Required': 1 },
            'helptext': {
               'Typecast': GTypecast.name }  },
         'ParentTags': ('gnurpc','service') },

      'raises': {
         'BaseClass': Objects.RpcRaises,
         'Attributes': {
            'name': {
               'References': (('exception','name'),),
               'Typecast': GTypecast.name,
               'Required': 1 } },
         'ParentTags': ('gnurpc','service') },
    }


  return xmlElements


#######################################################
#
# xmlHandler
#
# This class is called by the XML parser to
# process the xml file.
#
#######################################################

class xmlHandler (GParser.xmlHandler):
  def __init__(self):

    GParser.xmlHandler.__init__(self)

    self.xmlElements = getXMLelements()


