#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# forms/TemplateSupport.py
#
# DESCRIPTION:
# Provides forms-specific extensions to TemplateBase
#
# NOTES:
#

from gnue.designer.base.TemplateBase import *
from gnue.forms.GFForm import GFForm


def createRootObject(instance):
  return GFForm(app=instance)


###########################################################
#
# Base class for a form template
#
###########################################################
class FormTemplate(TemplateBase):

  # Initialize user code
  def Start(self, root, current):
    pass



###########################################################
#
# Base class for a form template which first lets user
# "pick" a position/size.
#
# Wizards using this template should not use the Start()
# initialization methods, but instead should use the
# StartWithPositioning().
#
###########################################################
class FormPrePositioningTemplate(FormTemplate):

  # Initialize user code
  def Start(self, root, current, **params):
    return self.StartWithPositioning(root, current,
          **params)


  def StartWithPositioning(self, root, current, x=0, y=0, 
                           width=None, height=None):
    pass


  def __init__(self, *args, **params):
    FormTemplate.__init__(self, *args, **params)

