# GNU Enterprise Forms - Curses UI Driver - Box Widget
#
# Copyright 2000-2005 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: box.py 6851 2005-01-03 20:59:28Z jcater $

import curses

from _base import UIHelper

# =============================================================================
# Box class
# =============================================================================

class UIBox (UIHelper):

  def _init (self, index):

    attr = self._uiDriver.attr ['background']

    w = self._gfObject ['Char:width']
    h = self._gfObject ['Char:height']

    for pos in range (self._x+1, self._x+w-1):
      self._parent.putchar (pos, self._y    , curses.ACS_HLINE, attr)
      self._parent.putchar (pos, self._y+h-1, curses.ACS_HLINE, attr)

    for line in range (self._y+1, self._y+h-1):
      self._parent.putchar (self._x    , line, curses.ACS_VLINE, attr)
      self._parent.putchar (self._x+w-1, line, curses.ACS_VLINE, attr)

    self._parent.putchar (self._x    , self._y    , curses.ACS_ULCORNER, attr)
    self._parent.putchar (self._x+w-1, self._y    , curses.ACS_URCORNER, attr)
    self._parent.putchar (self._x    , self._y+h-1, curses.ACS_LLCORNER, attr)
    self._parent.putchar (self._x+w-1, self._y+h-1, curses.ACS_LRCORNER, attr)

    self._parent.write (self._x+2, self._y, self._gfObject.label, attr)

# =============================================================================
# Configuration data
# =============================================================================

configuration = {
  'baseClass'  : UIBox,
  'provides'   : 'GFBox',
  'container'  : 0,
  }
