#!/bin/sh

# generate Makefile.am from gpal's processor list

echo "## This file was automatically generated by Makefile.sh" > Makefile.am
echo >> Makefile.am
echo "noinst_PROGRAMS = gp2pub" >> Makefile.am
echo >> Makefile.am
echo "AM_CPPFLAGS = -I\${top_srcdir}/libgputils -I\${top_srcdir}/include -I\${top_srcdir}/gpasm" >> Makefile.am
echo >> Makefile.am
echo "gp2pub_SOURCES = gp2pub.c" >> Makefile.am
echo >> Makefile.am
echo "gp2pub_LDADD = \${top_builddir}/gpasm/libgpasm.a \${top_builddir}/@LIBGPUTILS@ \${top_builddir}/@LIBIBERTY@" >> Makefile.am
echo >> Makefile.am
echo "pkgdatadir = @GPUTILS_PUB_PATH@" >> Makefile.am
echo >> Makefile.am
echo "PUB_FILES =\\" >> Makefile.am

# count the number of items in the list
let count=0
for x in `gpal -l | sort`
  do
    let count=count+1
  done

# output the file list
let pass=0
for x in `gpal -l | sort`
  do
    let pass=pass+1
    if [ -e ../header/$x.inc ]; then
      if [ $pass -eq $count ]; then
        echo "	$x.pub" >> Makefile.am
      else
        echo "	$x.pub \\" >> Makefile.am
      fi
    else
      echo "../header/$x.inc doesn't exist"
    fi
  done
  
echo >> Makefile.am
echo "%.asm: \${top_srcdir}/header/%.inc" >> Makefile.am
echo "	echo \"  processor\" \`echo \$@ | sed -e 's%.asm% %g'\` > \$@" >> Makefile.am
echo "	echo \"  include\" \$< >> \$@" >> Makefile.am
echo "	echo \"  end\" >> \$@" >> Makefile.am
echo >> Makefile.am
echo "%.pub: %.asm" >> Makefile.am
echo "	./gp2pub \$<" >> Makefile.am
echo >> Makefile.am
echo "pkgdata_DATA = \$(PUB_FILES)" >> Makefile.am
echo >> Makefile.am
echo "EXTRA_DIST = \$(PUB_FILES) Makefile.sh" >> Makefile.am
echo >> Makefile.am
echo "MAINTAINERCLEANFILES = \$(PUB_FILES)" >> Makefile.am
echo >> Makefile.am
echo "CLEANFILES = *.asm" >> Makefile.am
