/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2003 Bert Vermeulen
    Copyright (C) 2002-2003 Peter Stamfest

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: dn-browse.h,v 1.2 2003/11/02 07:20:43 stamfest Exp $ */

#ifndef GQ_DN_BROWSE_H_INCLUDED
#define GQ_DN_BROWSE_H_INCLUDED

#include "config.h"
#include "browse.h"

/**************************************************************************/
/*
 * A browse_entry describing a singe DN (eg. a single LDAP object)
 */
#define DN_BROWSE_ENTRY_ID	1
typedef struct {
     /* common */
     int type;
     struct browse_entry_vtab *base_methods;
     /* specific */
     char *dn;
     gboolean seen;
     gboolean leaf;
     gboolean uncache;

     gboolean is_ref; /* set if this entry is a referral and children
			 of it should thus become ref_browse_entry
			 objects */
} dn_browse_entry;

#define IS_DN_ENTRY(entry) IS_ENTRY((entry), DN_BROWSE_ENTRY_ID)
#define DN_BROWSE_ENTRY(x) ((dn_browse_entry*)(x))

browse_entry *new_dn_browse_entry(const char *dn);

#endif


/* 
   Local Variables:
   c-basic-offset: 5
   End:
 */

