#include "config.h"

#include "driver.h"
#include "connection.h"
#include "gql++/exception.h"

namespace GQL
{

namespace SQLite
{

using namespace std;

SQLiteDriver::SQLiteDriver(Yehia::PluginManager& mgr) 
    : Driver(mgr, "sqlite", "SQLite")
{
  set_version(0, 0);
}

bool SQLiteDriver::accept_url(const string& url) const
{
  return(parse_url(url).size() > 0);
}

Connection *SQLiteDriver::connect(const string& url,
                                  const map<string, string>& info)
{
  props_ = parse_url(url, info);

  if (props_.size() == 0)
    return(0);

  return manage(new SQLiteConnection(props_, database(), url, this));
}

vector<DriverPropertyInfo> SQLiteDriver::get_property_info(
        const string& url,
        const map<string, string>& props) const
{
  vector<DriverPropertyInfo> prop_info;

  return prop_info;
}
                                               
map<string, string> SQLiteDriver::parse_url(
        const string& url,
        const map<string, string>& defaults) const
{
  map<string, string> url_props(defaults);
  string::size_type pos = 0, new_pos;
  int state = 0;
  bool ok = false, done = false;
  
  for (;;)
  {
    new_pos = url.find_first_of(":/;=&?", pos);

    switch (state)
    {
      case 0:
        // First Part must be 'gql:'
        if (url[new_pos] != ':' ||
            url.substr(pos, new_pos - pos) != "gql")
          done = true;
        state++;
        break;
      case 1:
        // Then we need '<our ID>:'
        if (url[new_pos] != ':' ||
            url.substr(pos, new_pos - pos) != get_id())
          done = true;
        state++;
        break;
      case 2:
        // Then we have the dbname (filename)
        url_props["DBNAME"] = url.substr(pos);
        done = true;
        ok = true;
        break;
    }
    
    if (done)
      break;

    pos = new_pos + 1;
  }
  
  if (!ok)
    url_props.erase(url_props.begin(), url_props.end());
  
  return(url_props);
}

static string empty_string;

const string& SQLiteDriver::database() const
{
  map<string, string>::const_iterator i = props_.find("DBNAME");
  
  if (i == props_.end())
    return(empty_string);
  else
    return((*i).second);
}

extern "C" Yehia::Plugin *yehia_sqlite_plugin_init(Yehia::PluginManager *mgr)
{
  Driver *driver = manage(new SQLiteDriver(*mgr));
  driver->reference();

  return driver;
}


}
}

