%{
#include "gradm.h"
/* gradm grammar parser */

extern int gradmlex(void);

struct ip_acl ip;

void conv_name_to_type(char * name)
{
	struct protoent * proto;
	unsigned short i;

	if(!strcmp(name, "raw_proto"))
		ip.proto[IPPROTO_RAW / 32] |= (1 << (IPPROTO_RAW % 32));
	else if(!strcmp(name, "raw_sock"))
		ip.type |= (1 << SOCK_RAW);
	else if(!strcmp(name, "any_sock")) {
		ip.type = ~0;
		ip.type &= ~(1 << 0);  // there is no sock type 0
	} else if(!strcmp(name, "any_proto")) {
		for(i = 0; i < 8; i++)
			ip.proto[i] = ~0;
	} else if(!strcmp(name, "stream"))
		ip.type |= (1 << SOCK_STREAM);
	else if(!strcmp(name, "dgram"))
		ip.type |= (1 << SOCK_DGRAM);
	else if(!strcmp(name, "rdm"))
		ip.type |= (1 << SOCK_RDM);
	else if(!strcmp(name, "tcp")) { // silly protocol 0
		ip.proto[IPPROTO_IP / 32] |= (1 << (IPPROTO_IP % 32));
		ip.proto[IPPROTO_TCP / 32] |= (1 << (IPPROTO_TCP % 32));
	} else if(!strcmp(name, "udp")) { // silly protocol 0
		ip.proto[IPPROTO_IP / 32] |= (1 << (IPPROTO_IP % 32));
		ip.proto[IPPROTO_UDP / 32] |= (1 << (IPPROTO_UDP % 32));
	} else if((proto = getprotobyname(name)))
		ip.proto[proto->p_proto / 32] |= (1 << (proto->p_proto % 32));
	else {
		fprintf(stderr, "Invalid type/protocol: %s\n", name);
		exit(EXIT_FAILURE);
	}
	return;
}			

char * get_mask(char * ipwithmask)
{
	char *p = strchr(ipwithmask, '/');
	
	*p = '\0';
	p++;
	return p;
}

%}

%union {
	char *gr_tmpbuf;  
}

%token <gr_tmpbuf> ACL_SUBJECT ACL_MODE CAP_RAISE CAP_DROP INCLUDE INCLUDE_FNAME RES_ACL RES_ACL_MOD IP MASKPORT IPWITHMASK TYPE CONNECT BIND DISABLED

%%

acl_file:	proc_acl
	|	acl_file proc_acl
	;

proc_object_list:	/* empty */
		|	proc_object_list ACL_SUBJECT ACL_MODE 
		{ 
			if(!add_proc_object_acl(&def_acl_tmp->filp, $2, 
					proc_object_mode_conv($3),GR_FEXIST))
				exit(EXIT_FAILURE);
		}
		|	proc_object_list ACL_SUBJECT 
		{ 
			if(!add_proc_object_acl(&def_acl_tmp->filp, $2, 
					proc_object_mode_conv(""),GR_FEXIST))
				exit(EXIT_FAILURE);
		}
		| 	proc_object_list cap_acl
		|	proc_object_list res_acl
		|	proc_object_list ip_acl
		;

res_acl:	RES_ACL	RES_ACL_MOD RES_ACL_MOD
		{
			add_res_acl(&def_acl_tmp, $1, $2, $3);
		}
		;

ip_acl:		CONNECT '{' conn_ip_real_acl '}'
		{
			memset(&ip, 0, sizeof(ip));
		}
	|	CONNECT '{' DISABLED '}'
		{
			memset(&ip, 0, sizeof(ip));
			add_ip_acl(&(def_acl_tmp->ipp), GR_IP_CONNECT, &ip);
		}
	|	BIND '{' bind_ip_real_acl '}'
		{
			memset(&ip, 0, sizeof(ip));
		}
	|	BIND '{' DISABLED '}'
		{
			memset(&ip, 0, sizeof(ip));
			add_ip_acl(&(def_acl_tmp->ipp), GR_IP_BIND, &ip);
		}
	;

conn_ip_real_acl:	ip_ip_acl ip_type_acl
			{
				add_ip_acl(&(def_acl_tmp->ipp), GR_IP_CONNECT, &ip);
				memset(&ip, 0, sizeof(ip));
			}
	|	conn_ip_real_acl ip_ip_acl ip_type_acl
			{
				add_ip_acl(&(def_acl_tmp->ipp), GR_IP_CONNECT, &ip);
				memset(&ip, 0, sizeof(ip));
			}
	;

bind_ip_real_acl:	ip_ip_acl ip_type_acl
			{
				add_ip_acl(&(def_acl_tmp->ipp), GR_IP_BIND, &ip);
				memset(&ip, 0, sizeof(ip));
			}
	|	bind_ip_real_acl ip_ip_acl ip_type_acl
			{
				add_ip_acl(&(def_acl_tmp->ipp), GR_IP_BIND, &ip);
				memset(&ip, 0, sizeof(ip));
			}
	;

ip_type_acl:	TYPE
		{
			conv_name_to_type($1);
		}
	|	ip_type_acl TYPE
		{
			conv_name_to_type($2);
		}
	;

ip_ip_acl:	IP
		{
			add_ip_ip_acl(&ip, $1, "32", "0", "65535");
		}
	|	IPWITHMASK
		{
			char *netmask = get_mask($1);
			add_ip_ip_acl(&ip, $1, netmask, "0", "65535");
		}
	|	IPWITHMASK ':' MASKPORT
		{
			char *netmask = get_mask($1);
			add_ip_ip_acl(&ip, $1, netmask, $3, $3);
		}
	|	IPWITHMASK ':' MASKPORT '-' MASKPORT
		{
			char *netmask = get_mask($1);
			add_ip_ip_acl(&ip, $1, netmask, $3, $5);
		}
	|	IP ':' MASKPORT
		{
			add_ip_ip_acl(&ip, $1, "32", $3, $3);
		}
	|	IP ':' MASKPORT '-' MASKPORT
		{
			add_ip_ip_acl(&ip, $1, "32", $3, $5);
		}
	;
cap_acl:	CAP_DROP 
		{ 
			add_cap_acl(&def_acl_tmp, $1);
		}
	|	CAP_RAISE
		{
			add_cap_acl(&def_acl_tmp, $1);
		}
	;

proc_acl:	INCLUDE INCLUDE_FNAME 
		{
			add_include($2);
		}
	|	ACL_SUBJECT ACL_MODE '{' proc_object_list '}' 
		{ 	
			struct stat fstat;
			
			if(!stat($1, &fstat) && S_ISREG(fstat.st_mode)) {
				if(is_valid_elf_binary($1)) {
					if(!add_proc_object_acl(&def_acl_tmp->filp, $1, 
							proc_object_mode_conv("x"),GR_FLEARN))
						exit(EXIT_FAILURE);
				} else {
					if(!add_proc_object_acl(&def_acl_tmp->filp, $1, 
							proc_object_mode_conv("rx"),GR_FLEARN))
						exit(EXIT_FAILURE);
				}
			}
			if(!add_proc_subject_acl(&def_acl_tmp, $1, 
					proc_subject_mode_conv($2)))
				exit(EXIT_FAILURE);
		}
	|	ACL_SUBJECT '{' proc_object_list '}' 
		{ 
			struct stat fstat;
		
			if(!stat($1, &fstat) && S_ISREG(fstat.st_mode)) {
				if(is_valid_elf_binary($1)) {
					if(!add_proc_object_acl(&def_acl_tmp->filp, $1, 
							proc_object_mode_conv("x"),GR_FLEARN))
						exit(EXIT_FAILURE);
				} else {
					if(!add_proc_object_acl(&def_acl_tmp->filp, $1, 
							proc_object_mode_conv("rx"),GR_FLEARN))
						exit(EXIT_FAILURE);
				}
			}
			if(!add_proc_subject_acl(&def_acl_tmp, $1, 
					proc_subject_mode_conv("")))
				exit(EXIT_FAILURE);
		}
	;
%%
