/*
 * Pixmap and Bitmap(mask) pair-data header
 *
 * I know GtkPixmap or GnomePixmap provide a similar functionality,
 * but they are still too much for me.
 * So I made this module.
 * This is almost a wrapper of gdk_imlib_load_file_to_pixmap().
 * The instances are managed by GroTheme, but referred by GroMove.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */

#ifndef __GRO_GROPIXMAP_H__
#define __GRO_GROPIXMAP_H__

/** Library private **/
#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
	
/* Data structure definitions */
typedef struct _GroPixmap GroPixmap;
struct _GroPixmap {
	GdkPixmap *pixmap;
	GdkBitmap *mask;
};

/* Global function declarations */
extern GroPixmap* gro_pixmap_new(const char *filename, const char *dirname, guint pix_width, guint pix_height);
extern void gro_pixmap_delete(GroPixmap *gro_pixmap);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GRO_GROPIXMAP_H__ */
