/*
 * Drawing window header
 *
 * Data strucure that represents a window to draw.
 * In fact, it wraps GdkWindow.
 * Default window is the root window.
 * The instance is referred by GroController.
 * One ugly point is that the instance is allocated by external module
 * out of the library.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GRO_GROWIN_H__
#define __GRO_GROWIN_H__

#include "guimisc.h"

/** Library private **/
#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* Data structure definition */
typedef struct _GroWindow GroWindow;

/* Window for drawing GroMoves */
struct _GroWindow {
	GdkWindow *window;
	GdkGC *gc;
};

/* Global function declarations */
extern GroWindow* gro_window_new(GdkWindow *window);
extern void gro_window_delete(GroWindow *gro_win);

/* Macro interfaces */
/* Return width of @gro_win */
#define gro_window_width(gro_win)	\
	(_gdk_window_get_width(gro_win->window))
/* Return height of @gro_win */
#define gro_window_height(gro_win)	\
	(_gdk_window_get_height(gro_win->window))
/* Return GdkRectangle *ret_rect of @gro_win */
#define gro_window_rectangle(gro_win, ret_rect) G_STMT_START {	\
	(ret_rect)->x = (ret_rect)->y = 0;					\
	(ret_rect)->width = gro_window_width(gro_win);		\
	(ret_rect)->height = gro_window_height(gro_win);	\
} G_STMT_END

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GRO_GROWIN_H__ */
