
/* gtkextramm_marshal.cc
 *
 * Copyright (C) 2000 GtkExtra-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gtkextramm_marshal.h"

//Gtk-- marshallers for Gtk+Extra marshallers. See Signals:

typedef gint (*GtkSignal_BOOL__INT_INT_POINTER_POINTER) (GtkObject * object,
							     gint arg1,
							     gint arg2,
							     gpointer arg3,
							     gpointer arg4,
							gpointer user_data);

void gtkmm_marshal_BOOL__INT_INT_POINTER_POINTER (GtkObject * object,
                                              GtkSignalFunc func,
                                              gpointer func_data,
                                              GtkArg * args)
{
  GtkSignal_BOOL__INT_INT_POINTER_POINTER rfunc;
  gint *return_val, rc;
  return_val = GTK_RETLOC_INT (args[4]);
  rfunc = (GtkSignal_BOOL__INT_INT_POINTER_POINTER) func;
  gtkmm_clear_ignore();
  rc = (*rfunc) (object,
			  GTK_VALUE_INT (args[0]),
			  GTK_VALUE_INT (args[1]),
			  GTK_VALUE_POINTER (args[2]),
			  GTK_VALUE_POINTER (args[3]),
			  func_data);
  if (!gtkmm_clear_ignore()) *return_val=rc;
  //gtkmm_clear_ignore() gets current value of ignore_, then sets it to false. 
}

typedef gboolean (*GtkSignal_BOOL__INT_INT) (GtkObject * object,
							     gint arg1,
							     gint arg2,
							gpointer user_data);

void gtkmm_marshal_BOOL__INT_INT (GtkObject * object,
                                              GtkSignalFunc func,
                                              gpointer func_data,
                                              GtkArg * args)
{
  GtkSignal_BOOL__INT_INT rfunc;
  gboolean *return_val, rc;
  return_val = GTK_RETLOC_INT (args[2]);
  rfunc = (GtkSignal_BOOL__INT_INT) func;
  gtkmm_clear_ignore();
  rc = (*rfunc) (object,
			  GTK_VALUE_INT (args[0]),
			  GTK_VALUE_INT (args[1]),
			  func_data);
  if (!gtkmm_clear_ignore()) *return_val=rc;
  //gtkmm_clear_ignore() gets current value of ignore_, then sets it to false. 
}


typedef gboolean (*GtkSignal_BOOL__POINTER_POINTER) (GtkObject * object,
							     gpointer arg1,
							     gpointer arg2,
							gpointer user_data);                             

void gtkmm_marshal_BOOL__POINTER_POINTER (GtkObject * object,
                                              GtkSignalFunc func,
                                              gpointer func_data,
                                              GtkArg * args)
{
  GtkSignal_BOOL__POINTER_POINTER rfunc;
  gboolean *return_val, rc;
  return_val = GTK_RETLOC_INT (args[2]);
  rfunc = (GtkSignal_BOOL__POINTER_POINTER) func;
  gtkmm_clear_ignore();
  rc = (*rfunc) (object,
			  GTK_VALUE_POINTER (args[0]),
			  GTK_VALUE_POINTER (args[1]),
			  func_data);
  if (!gtkmm_clear_ignore()) *return_val=rc;
  //gtkmm_clear_ignore() gets current value of ignore_, then sets it to false. 
}


typedef gint (*GtkSignal_INT__POINTER_POINTER) (GtkObject * object,
							     gpointer arg1,
							     gpointer arg2,
							gpointer user_data);                             

void gtkmm_marshal_INT__POINTER_POINTER (GtkObject * object,
                                              GtkSignalFunc func,
                                              gpointer func_data,
                                              GtkArg * args)
{
  GtkSignal_INT__POINTER_POINTER rfunc;
  gint *return_val, rc;
  return_val = GTK_RETLOC_INT (args[2]);
  rfunc = (GtkSignal_INT__POINTER_POINTER) func;
  gtkmm_clear_ignore();
  rc = (*rfunc) (object,
			  GTK_VALUE_POINTER (args[0]),
			  GTK_VALUE_POINTER (args[1]),
			  func_data);
  if (!gtkmm_clear_ignore()) *return_val=rc;
  //gtkmm_clear_ignore() gets current value of ignore_, then sets it to false. 
}


typedef gint (*GtkSignal_INT__POINTER_INT_INT) (GtkObject * object,
							     gpointer arg1,
							     gpointer arg2,
							     gint arg3,
							gpointer user_data);                             

void gtkmm_marshal_INT__POINTER_INT_INT (GtkObject * object,
                                              GtkSignalFunc func,
                                              gpointer func_data,
                                              GtkArg * args)
{
  GtkSignal_INT__POINTER_INT_INT rfunc;
  gint *return_val, rc;
  return_val = GTK_RETLOC_INT (args[3]);
  rfunc = (GtkSignal_INT__POINTER_INT_INT) func;
  gtkmm_clear_ignore();
  rc = (*rfunc) (object,
			  GTK_VALUE_POINTER (args[0]),
			  GTK_VALUE_POINTER (args[1]),
			  GTK_VALUE_INT (args[2]),
			  func_data);
  if (!gtkmm_clear_ignore()) *return_val=rc;
  //gtkmm_clear_ignore() gets current value of ignore_, then sets it to false. 
}

