/* build_keyboard.h
 *
 * For use with GTKeyboard 
 * written by David Allen s2mdalle@titan.vcu.edu
 * http://opop.nols.com/
 *
 * Released under the terms of the GNU General Public License, see COPYING
 * for more details
 *
 * This file holds keyboard definitions for various different layouts.
 *
 */

#define BUILD_KEYBOARD_H
/* Define which xpm's we need compiled in */

/* Please uncomment the line that you need for the keyboard of your choice.
 * The default keyboard is STANDARD_KEYBOARD, which is a regular US keyboard.
 * The french keyboard is ridiculously far from done, so if you choose to use
 * that one, be prepared for the application probably not to work.  Sorry.
 */

#ifdef BUILD_KEYBOARD_C
#define USE_CURSOR_RIGHT
#define USE_CURSOR_LEFT
#define USE_CURSOR_UP
#define USE_CURSOR_DOWN
#include "../xpm/cursor_foo.h"
#endif /* BUILD_KEYBOARD_C */

/* Various keyboards are included only for app.c and build_keyboard.c
 * in master.h
 */

/* Just make them all different - gets passed to build_an_entire_keyboard */
/* Not used yet.. */
#define SHOW_STANDARD_KEYBOARD              50
#define SHOW_GERMAN_KEYBOARD                51
#define SHOW_FRENCH_KEYBOARD                52
#define SHOW_DVORAK_KEYBOARD                53
#define SHOW_SPANISH_KEYBOARD               54
#define SHOW_ITALIAN_KEYBOARD               55
#define SHOW_COOLKEY_KEYBOARD               56

/* Local defines for what keys appear as */
#define RIGHT_KEY                           "  -->  "
#define LEFT_KEY                            "  <--  "

/*
 * Check the notes at the bottom of the page for an ASCII drawing of how the
 * keyboard should look
 *
 * Each button is defined as a character string of two characters.  The first
 * is what you get when SHIFT || CAPS_LOCK > 0 and the second is the normal
 * key function.  This function loops through grabbing two characters at a
 * time and then calling makekeybutton to set things up and map the
 * callback to the key and so on.
 *
 * SPECIAL CASES WITHIN stuff[]:  (Yes it's braindamaged)
 * LL is the left cursor key
 * RR is the right cursor key
 * || is caps lock key
 * \\ (or escaped, it's \\\\) is SHIFT key
 * CC is control
 * AA is alt
 *
*/

/* PROTOTYPES - Most functions in build_keyboard.c are static and don't need
 * prototypes here.
 */
void destroy_key_widget_data                 (gpointer data);
void keysym_callback                         (GtkWidget *emitter, 
					      gpointer data);
void grab_smack                              (GtkWidget *e, gpointer d);
void custom_keyboard_file_dialog             (GtkWidget *emitter, 
					      gpointer data);
void switch_keydefs                          (gint keyboardID);
void switch_keyboard                         (GtkWidget *emitter, 
					      gpointer data);
GtkWidget *build_an_entire_keyboard          (GtkWidget *emitter, 
					      char *filename);








