/* file_manip.h
 * 
 * For use with GTKeyboard
 * written by David Allen s2mdalle@titan.vcu.edu
 * This file is released under the terms of the GNU General Public License
 */
#define FILE_MANIP_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <gtk/gtk.h>

#define SMALL_BUFFER    20
#define BIG_BUFFER      32

#define LINE_TOKENS                   3
#define	MAX_LINE_LENGTH	              128
#define	TOKEN_SIZE	              50
#define DEFAULT_RCFILE  "# Default .gtkeyboardrc file written by GTKeyboard\nkeyboard main_keyboard on\nkeyboard number_pad on\nkeyboard cursor_keys on\nkeyboard f_keys on\n\nset handlebars off\n\nset word_wrap off\nset info_popups on\nset bump_amount 15\nhide buttonbar\nset random_strlen 10\nset eyecandy off\nset redirect_policy implicit\n"



#define OPT_IS_GOOD(x)     (!(g_strcasecmp(x,"show")) ||\
                            !(g_strcasecmp(x,"on")) ||\
                            (atoi(x) == 1))
#define CHECK(var, const)  ((g_strcasecmp(var,const) == 0))

#define STAT_AND_RETURN_IF_BAD(fname, someint, statstruct) \
                                   if(!fname)return(0);\
                                   someint = stat(fname, &statstruct);\
                                   if(someint<0) return(0);

/* List of strings - GTKeyboard is really looking for these when it
 * reads the rcfiles.  These are the options it recognizes.  To the user,
 * they aren't case sensitive, but here, they must ALL be specified in all caps
 */
#define OPT_ASK_SAVE                 "ASK_SAVE_ON_EXIT"
#define OPT_CACHE_FILE               "CACHE_FILE"
#define OPT_REDIRECT_POLICY          "REDIRECT_POLICY"
#define OPT_XPOS                     "XPOS"
#define OPT_YPOS                     "YPOS"
#define OPT_KEYBOARD_FILE            "KEYBOARD_FILE"
#define OPT_EXTRA_FILES              "EXTRA_FILES"
#define OPT_WORD_WRAP                "WORD_WRAP"
#define OPT_IGNORE_LAYOUT_FILE       "IGNORE_LAYOUT_FILE"
#define OPT_SEND_TO_BOTH_WINDOWS     "SEND_DATA_TO_BOTH_WINDOWS"
#define OPT_SHOW_TOOLTIPS            "SHOW_TOOLTIPS"
#define OPT_PULLOFFS                 "PULLOFFS"
#define OPT_HANDLEBOXES              "HANDLEBARS"
#define OPT_BORDERLESS               "BORDERLESS"
#define OPT_STATUS_LOGGING           "STATUS_LOGGING"
#define OPT_WORKING_FILE             "WORKING_FILE"
#define OPT_RAND_STRING_LENGTH       "RANDOM_STRLEN"
#define OPT_SMALL_WINDOWS            "SMALL_WINDOWS"
#define OPT_SHOW_TEXT                "SHOW_TEXT"
#define OPT_BUMP_AMOUNT              "BUMP_AMOUNT"
#define OPT_INFO_POPUPS              "INFO_POPUPS"
#define OPT_RANDOMIZE_XPMS           "RANDOMIZE_XPMS"
#define OPT_EYECANDY                 "EYECANDY"

#define OPT_KEYBOARD_FONT            "KEYBOARD_FONT"
#define OPT_TEXT_FONT                "TEXT_FONT"

/* Prototypes - creeping evil */
void parse_user_resource_file         (char *filename);
int parse_show_hide                   (char *prefix, char *varname, 
				       char *val, gpointer ptr);
int parse_pulloffs_side               (char *prefix, char *varname, 
				       char *val, gpointer ptr);
int parse_redirect_policy             (char *prefix, char *varname, 
				       char *val, gpointer ptr);
void FILE_readline                    (FILE *fp, char *buffer, 
				       const int maxlen);
char *expand_relative_pathname        (char *filename);
int gtkeyboard_load_shortcuts         (void);
void gtkeyboard_save_shortcuts        (GtkWidget *widget, gpointer data);
int setup_default_rcfile              (char *file);
int is_fifo                           (const char *filename);
int is_link                           (const char *filename);
int is_executable                     (const char *filename);
int file_exists                       (const char *filename);
int is_regular_file                   (const char *filename);

/* EOF */
