/* MASTER.H
 * For use with GTKeyboard
 * Written by David Allen
 * s2mdalle@titan.vcu.edu http://opop.nols.com
 *
 * This file is distributable under the terms of the GNU General Public License
 * See COPYING or www.gnu.org for more information.
 */

#define PROD

#ifndef PROD /* Non-Production release, add memory debugging nonsense */
#  define GTKEYBOARD_MEMORY_DEBUGGING                  1
#  ifndef DEBUGGING
#    define DEBUGGING
#  endif /* DEBUGGING */
#endif /* PROD */

#ifdef DEBUGGING
#  define PRINT_STATUS_MESSAGES
#endif /* DEBUGGING */

#define MASTER_H       /* Define filename */

#define PROD

/* Ye olde #include's */
#include "config.h"
#include "include/checkheaders.h"    /* Check their headers */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <errno.h>
#include <signal.h>

#ifndef WCOMP_H
#  include "libwcomp/wcomp.h"
#endif

#ifdef HAVE_DIRENT_H
#  include <dirent.h>
#endif

#ifdef HAVE_SYS_STAT_H
#  include <sys/stat.h>
#endif /* HAVE_SYS_STAT_H */

#ifdef HAVE_UNISTD_H
#  include <unistd.h>
#endif /* HAVE_UNISTD_H */

#ifdef HAVE_CTYPE_H
#  include <ctype.h>
#endif /* HAVE_CTYPE_H */

#ifdef HAVE_ASSERT_H
#  include <assert.h>
#endif /* HAVE_ASSERT_H */

#ifdef TIME_WITH_SYS_TIME
#  include <time.h>
#  include <sys/time.h>
#else
#  include <time.h>
#endif /* TIME_WITH_SYS_TIME */

#ifndef MEM_HEADER_H
#  include "include/mem_header.h"
#endif /* MEM_HEADER_H */

/* INCLUDES FOR winselect and irxevent - without these, gcc instead spits out
 * dirty novels in russian as a result of expanded macros -- never knew that
 * about the Xlib headers, did you, hmmm???  :)
 */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xos.h>
#include <X11/extensions/shape.h>
#include <X11/Xmu/WinUtil.h>
#include <X11/cursorfont.h>
#include <X11/keysym.h>

#ifndef MODMAP_H
#  include "include/modmap.h"
#endif /* MODMAP_H */

#ifndef COMPLETER_H
#  include "include/completer.h"
#endif /* COMPLETER_H */

#ifndef MENUS_H
#  include "include/menus.h"
#endif /* MENUS_H */

#ifndef TEMPLATES_H
#  include "include/templates.h"
#endif /* TEMPLATES_H */

#ifndef FOLLOW_FOCUS_H
#  include "include/follow_focus.h"
#endif /* FOLLOW_FOCUS_H */

#ifndef KMANIP_H
#  include "include/kmanip.h"
#endif /* KMANIP_H */

/* Internal headers */
#ifndef RC_FILE_H
#  include "include/rc_file.h"
#endif /* RC_FILE_H */

#ifndef MIMIC_H
#  include "include/mimic.h"
#endif /* MIMIC_H */

#ifndef REMOTE_CONTROL_H
#  include "include/remote_control.h"
#endif /* REMOTE_CONTROL_H */

#ifndef MACRO_FU_H 
#  include "include/macro-fu.h"
#endif /* MACRO_FU_H */

#ifndef ADT_H
#  include "include/adt.h"
#endif /* ADT_H */

#include "include/file_manip.h"

#ifndef APP_H
#  include "include/app.h"
#endif /* APP_H */

#include "include/irxevent.h"            /* Please */
#include "include/ext_progs.h"
#include "include/build_keyboard.h"
#include "include/ranges.h"
#include "include/user_shortcuts.h"
#include "include/misc_cursor.h"
#include "include/truly_misc.h"
#include "include/shortcuts.h"
#include "include/callbacks.h"
/* Much of this next one won't be included if INCLUDE_HTML isn't defined */
#include "include/html.h"
#include "include/stylish.h"
#ifndef UI_H
#  include "include/ui.h"
#endif /* UI_H */

#ifndef WINSELECT_H
#  include "include/winselect.h"
#endif

/* GLOBAL VARIABLE UGLINESS */
GtkWidget *output_container;        /* What gets hidden/shown from truly_misc*/
GtkWidget *window;                  /* Main window from ui.c */
Window redirect_to;
int *fargc;
char **fargv;

/* Main program options - do not declare as static - all global */
GTKeyboardOptions  options;
GTKeyboardGUI      GUI;
GTKeyboardElements ELEMENTS;
GTKeyboardToolbar  Toolbar;

#define USE_GDK_CURSORS /* Undefine this and the cursors menu will not be
			 * present
			 */
/* EOF */
